/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.JobStateSnapshot;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.core.JobSuspensionCause;
import com.hazelcast.jet.core.metrics.JobMetrics;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Job {
    public boolean isLightJob();

    public long getId();

    @Nonnull
    default public String getIdString() {
        return Util.idToString(this.getId());
    }

    default public void join() {
        this.getFuture().join();
    }

    @Nonnull
    public CompletableFuture<Void> getFuture();

    public void cancel();

    public long getSubmissionTime();

    @Nullable
    default public String getName() {
        if (this.isLightJob()) {
            return null;
        }
        return this.getConfig().getName();
    }

    @Nonnull
    public JobStatus getStatus();

    @Nonnull
    public JobConfig getConfig();

    @Nonnull
    public JobSuspensionCause getSuspensionCause();

    @Nonnull
    public JobMetrics getMetrics();

    public void restart();

    public void suspend();

    public void resume();

    public JobStateSnapshot cancelAndExportSnapshot(String var1);

    public JobStateSnapshot exportSnapshot(String var1);
}

