/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.client.job;

import com.hazelcast.internal.serialization.Data;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.seatunnel.engine.client.SeaTunnelHazelcastClient;
import org.apache.seatunnel.engine.common.utils.MDUtil;
import org.apache.seatunnel.engine.core.job.ConnectorJar;
import org.apache.seatunnel.engine.core.job.ConnectorJarIdentifier;
import org.apache.seatunnel.engine.core.job.ConnectorJarType;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelUploadConnectorJarCodec;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class ConnectorPackageClient {
    private final SeaTunnelHazelcastClient hazelcastClient;

    public ConnectorPackageClient(SeaTunnelHazelcastClient hazelcastClient) {
        Preconditions.checkNotNull((Object)hazelcastClient);
        this.hazelcastClient = hazelcastClient;
    }

    public Set<ConnectorJarIdentifier> uploadCommonPluginJars(long jobId, List<URL> commonPluginJars) {
        HashSet<ConnectorJarIdentifier> connectorJarIdentifiers = new HashSet<ConnectorJarIdentifier>();
        for (URL commonPluginJar : commonPluginJars) {
            Path path = commonPluginJar.getPath().startsWith("/") ? Paths.get(commonPluginJar.getPath().substring(1), new String[0]) : Paths.get(commonPluginJar.getPath(), new String[0]);
            ConnectorJarIdentifier connectorJarIdentifier = this.uploadCommonPluginJar(jobId, path);
            connectorJarIdentifiers.add(connectorJarIdentifier);
        }
        return connectorJarIdentifiers;
    }

    private ConnectorJarIdentifier uploadCommonPluginJar(long jobId, Path commonPluginJar) {
        byte[] data = ConnectorPackageClient.readFileData(commonPluginJar);
        String fileName = commonPluginJar.getFileName().toString();
        MessageDigest messageDigest = MDUtil.createMessageDigest();
        byte[] digest = messageDigest.digest(data);
        ConnectorJar connectorJar = ConnectorJar.createConnectorJar((byte[])digest, (ConnectorJarType)ConnectorJarType.COMMON_PLUGIN_JAR, (byte[])data, (String)fileName);
        return (ConnectorJarIdentifier)this.hazelcastClient.getSerializationService().toObject(this.hazelcastClient.requestOnMasterAndDecodeResponse(SeaTunnelUploadConnectorJarCodec.encodeRequest((long)jobId, (Data)this.hazelcastClient.getSerializationService().toData((Object)connectorJar)), SeaTunnelUploadConnectorJarCodec::decodeResponse));
    }

    public ConnectorJarIdentifier uploadConnectorPluginJar(long jobId, URL connectorPluginJarURL) {
        Path connectorPluginJarPath = Paths.get(connectorPluginJarURL.getPath().substring(1), new String[0]);
        byte[] data = ConnectorPackageClient.readFileData(connectorPluginJarPath);
        String fileName = connectorPluginJarPath.getFileName().toString();
        MessageDigest messageDigest = MDUtil.createMessageDigest();
        byte[] digest = messageDigest.digest(data);
        ConnectorJar connectorJar = ConnectorJar.createConnectorJar((byte[])digest, (ConnectorJarType)ConnectorJarType.CONNECTOR_PLUGIN_JAR, (byte[])data, (String)fileName);
        return (ConnectorJarIdentifier)this.hazelcastClient.getSerializationService().toObject(this.hazelcastClient.requestOnMasterAndDecodeResponse(SeaTunnelUploadConnectorJarCodec.encodeRequest((long)jobId, (Data)this.hazelcastClient.getSerializationService().toData((Object)connectorJar)), SeaTunnelUploadConnectorJarCodec::decodeResponse));
    }

    private static byte[] readFileData(Path filePath) {
        try {
            return Files.readAllBytes(filePath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

