/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.job;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.seatunnel.common.config.Common;
import org.apache.seatunnel.common.utils.FileUtils;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.common.utils.IdGenerator;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDag;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDagGenerator;
import org.apache.seatunnel.engine.core.job.ConnectorJarIdentifier;
import org.apache.seatunnel.engine.core.parse.MultipleTableJobConfigParser;

public abstract class AbstractJobEnvironment {
    protected static ILogger LOGGER = null;
    protected final boolean isStartWithSavePoint;
    protected final List<Action> actions = new ArrayList<Action>();
    protected final Set<URL> jarUrls = new HashSet<URL>();
    protected final Set<ConnectorJarIdentifier> connectorJarIdentifiers = new HashSet<ConnectorJarIdentifier>();
    protected final JobConfig jobConfig;
    protected final IdGenerator idGenerator;
    protected final List<URL> commonPluginJars = new ArrayList<URL>();

    public AbstractJobEnvironment(JobConfig jobConfig, boolean isStartWithSavePoint) {
        LOGGER = Logger.getLogger((String)this.getClass().getName());
        this.jobConfig = jobConfig;
        this.isStartWithSavePoint = isStartWithSavePoint;
        this.idGenerator = new IdGenerator();
        this.commonPluginJars.addAll(this.searchPluginJars());
    }

    protected Set<URL> searchPluginJars() {
        try {
            if (Files.exists(Common.pluginRootDir(), new LinkOption[0])) {
                return new HashSet<URL>(FileUtils.searchJarFiles((Path)Common.pluginRootDir()));
            }
        }
        catch (IOException | SeaTunnelEngineException e) {
            LOGGER.warning(String.format("Can't search plugin jars in %s.", Common.pluginRootDir()), e);
        }
        return Collections.emptySet();
    }

    public static void addCommonPluginJarsToAction(Action action, Set<URL> commonPluginJars, Set<ConnectorJarIdentifier> commonJarIdentifiers) {
        action.getJarUrls().addAll(commonPluginJars);
        action.getConnectorJarIdentifiers().addAll(commonJarIdentifiers);
        if (!action.getUpstream().isEmpty()) {
            action.getUpstream().forEach(upstreamAction -> AbstractJobEnvironment.addCommonPluginJarsToAction(upstreamAction, commonPluginJars, commonJarIdentifiers));
        }
    }

    public static Set<URL> getJarUrlsFromIdentifiers(Set<ConnectorJarIdentifier> connectorJarIdentifiers) {
        HashSet<URL> jarUrls = new HashSet<URL>();
        connectorJarIdentifiers.stream().map(connectorJarIdentifier -> {
            File storageFile = new File(connectorJarIdentifier.getStoragePath());
            try {
                return Optional.of(storageFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                LOGGER.warning(String.format("Cannot get plugin URL: {%s}", storageFile));
                return Optional.empty();
            }
        }).collect(Collectors.toList()).forEach(optional -> {
            if (optional.isPresent()) {
                jarUrls.add((URL)optional.get());
            }
        });
        return jarUrls;
    }

    protected abstract MultipleTableJobConfigParser getJobConfigParser();

    protected LogicalDagGenerator getLogicalDagGenerator() {
        return new LogicalDagGenerator(this.actions, this.jobConfig, this.idGenerator, this.isStartWithSavePoint);
    }

    public abstract LogicalDag getLogicalDag();
}

