/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema.map;

import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import com.hazelcast.sql.impl.schema.map.AbstractMapTable;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.schema.map.MapTableIndex;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public class PartitionedMapTable
extends AbstractMapTable {
    private final List<MapTableIndex> indexes;
    private final boolean hd;

    public PartitionedMapTable(String schemaName, String tableName, String mapName, List<TableField> fields, TableStatistics statistics, QueryTargetDescriptor keyDescriptor, QueryTargetDescriptor valueDescriptor, Object keyJetMetadata, Object valueJetMetadata, List<MapTableIndex> indexes, boolean hd) {
        super(schemaName, tableName, mapName, fields, statistics, keyDescriptor, valueDescriptor, keyJetMetadata, valueJetMetadata);
        this.indexes = indexes;
        this.hd = hd;
    }

    @Override
    public PlanObjectKey getObjectKey() {
        if (!this.isValid()) {
            return null;
        }
        return new PartitionedMapPlanObjectKey(this.getSchemaName(), this.getSqlName(), this.getMapName(), this.getFields(), this.getConflictingSchemas(), this.getKeyDescriptor(), this.getValueDescriptor(), this.getKeyJetMetadata(), this.getValueJetMetadata(), this.getIndexes(), this.isHd());
    }

    public List<MapTableIndex> getIndexes() {
        this.checkException();
        return this.indexes != null ? this.indexes : Collections.emptyList();
    }

    public boolean isHd() {
        return this.hd;
    }

    public Stream<MapTableField> keyFields() {
        return this.getFields().stream().map(field -> (MapTableField)field).filter(field -> field.getPath().isKey());
    }

    public Stream<MapTableField> valueFields() {
        return this.getFields().stream().map(field -> (MapTableField)field).filter(field -> !field.getPath().isKey());
    }

    public QueryPath[] paths() {
        return (QueryPath[])this.getFields().stream().map(field -> ((MapTableField)field).getPath()).toArray(QueryPath[]::new);
    }

    public QueryDataType[] types() {
        return (QueryDataType[])this.getFields().stream().map(TableField::getType).toArray(QueryDataType[]::new);
    }

    public QueryPath[] valuePaths() {
        return (QueryPath[])this.valueFields().map(MapTableField::getPath).toArray(QueryPath[]::new);
    }

    public QueryDataType[] valueTypes() {
        return (QueryDataType[])this.valueFields().map(TableField::getType).toArray(QueryDataType[]::new);
    }

    static class PartitionedMapPlanObjectKey
    implements PlanObjectKey {
        private final String schemaName;
        private final String tableName;
        private final String mapName;
        private final List<TableField> fields;
        private final QueryTargetDescriptor keyDescriptor;
        private final QueryTargetDescriptor valueDescriptor;
        private final Object keyJetMetadata;
        private final Object valueJetMetadata;
        private final List<MapTableIndex> indexes;
        private final boolean hd;
        private final Set<String> conflictingSchemas;

        PartitionedMapPlanObjectKey(String schemaName, String tableName, String mapName, List<TableField> fields, Set<String> conflictingSchemas, QueryTargetDescriptor keyDescriptor, QueryTargetDescriptor valueDescriptor, Object keyJetMetadata, Object valueJetMetadata, List<MapTableIndex> indexes, boolean hd) {
            this.schemaName = schemaName;
            this.tableName = tableName;
            this.mapName = mapName;
            this.fields = fields;
            this.keyDescriptor = keyDescriptor;
            this.valueDescriptor = valueDescriptor;
            this.keyJetMetadata = keyJetMetadata;
            this.valueJetMetadata = valueJetMetadata;
            this.indexes = indexes;
            this.hd = hd;
            this.conflictingSchemas = conflictingSchemas;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionedMapPlanObjectKey that = (PartitionedMapPlanObjectKey)o;
            return this.hd == that.hd && this.schemaName.equals(that.schemaName) && this.tableName.equals(that.tableName) && this.mapName.equals(that.mapName) && this.fields.equals(that.fields) && this.keyDescriptor.equals(that.keyDescriptor) && this.valueDescriptor.equals(that.valueDescriptor) && Objects.equals(this.keyJetMetadata, that.keyJetMetadata) && Objects.equals(this.valueJetMetadata, that.valueJetMetadata) && this.indexes.equals(that.indexes) && this.conflictingSchemas.equals(that.conflictingSchemas);
        }

        public int hashCode() {
            int result = this.schemaName.hashCode();
            result = 31 * result + this.tableName.hashCode();
            result = 31 * result + this.mapName.hashCode();
            result = 31 * result + this.fields.hashCode();
            result = 31 * result + this.keyDescriptor.hashCode();
            result = 31 * result + this.valueDescriptor.hashCode();
            result = 31 * result + Objects.hashCode(this.keyJetMetadata);
            result = 31 * result + Objects.hashCode(this.valueJetMetadata);
            result = 31 * result + this.indexes.hashCode();
            result = 31 * result + (this.hd ? 1 : 0);
            result = 31 * result + this.conflictingSchemas.hashCode();
            return result;
        }
    }
}

