/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.event;

import java.util.List;
import org.apache.seatunnel.api.event.Event;
import org.apache.seatunnel.api.event.EventHandler;
import org.apache.seatunnel.api.event.EventListener;
import org.apache.seatunnel.api.event.EventProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventProcessor
implements EventListener,
EventProcessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultEventProcessor.class);
    private final String jobId;
    private final List<EventHandler> handlers;

    public DefaultEventProcessor() {
        this(DefaultEventProcessor.class.getClassLoader());
    }

    public DefaultEventProcessor(String jobId) {
        this(jobId, EventProcessor.loadEventHandlers(DefaultEventProcessor.class.getClassLoader()));
    }

    public DefaultEventProcessor(ClassLoader classLoader) {
        this(null, EventProcessor.loadEventHandlers(classLoader));
    }

    @Override
    public void process(Event event) {
        this.handlers.forEach(listener -> listener.handle(event));
    }

    @Override
    public void onEvent(Event event) {
        if (this.jobId != null) {
            event.setJobId(this.jobId);
        }
        this.process(event);
    }

    @Override
    public void close() throws Exception {
        log.info("Closing event handlers.");
        EventProcessor.close(this.handlers);
    }

    public DefaultEventProcessor(String jobId, List<EventHandler> handlers) {
        this.jobId = jobId;
        this.handlers = handlers;
    }
}

