/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.http;

import jakarta.ws.rs.core.Response;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.servicecomb.foundation.common.http.HttpStatus;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;

public class HttpStatusManager {
    private final Map<Integer, Response.StatusType> statusMap = new ConcurrentHashMap<Integer, Response.StatusType>();

    public HttpStatusManager() {
        for (Response.Status status : Response.Status.values()) {
            this.statusMap.put(status.getStatusCode(), (Response.StatusType)status);
        }
        SPIServiceUtils.getAllService(Response.StatusType.class).forEach(this::addStatusType);
    }

    public void addStatusType(Response.StatusType status) {
        if (this.statusMap.containsKey(status.getStatusCode())) {
            throw new IllegalStateException("repeated status code: " + status.getStatusCode());
        }
        this.statusMap.put(status.getStatusCode(), status);
    }

    public Response.StatusType getOrCreateByStatusCode(int code) {
        Response.StatusType statusType = this.statusMap.get(code);
        if (statusType != null) {
            return statusType;
        }
        statusType = new HttpStatus(code, "");
        this.addStatusType(statusType);
        return statusType;
    }
}

