/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.metadata;

import java.util.Optional;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.metadata.SchemaChangedHandler;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.metadata.StorageNodeChangedHandler;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.metadata.StorageUnitChangedHandler;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.metadata.TableChangedHandler;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.metadata.ViewChangedHandler;
import org.apache.shardingsphere.mode.node.path.metadata.DataSourceMetaDataNodePath;
import org.apache.shardingsphere.mode.node.path.metadata.DatabaseMetaDataNodePath;
import org.apache.shardingsphere.mode.node.path.metadata.TableMetaDataNodePath;
import org.apache.shardingsphere.mode.node.path.metadata.ViewMetaDataNodePath;

public final class MetaDataChangedHandler {
    private final SchemaChangedHandler schemaChangedHandler;
    private final TableChangedHandler tableChangedHandler;
    private final ViewChangedHandler viewChangedHandler;
    private final StorageUnitChangedHandler storageUnitChangedHandler;
    private final StorageNodeChangedHandler storageNodeChangedHandler;

    public MetaDataChangedHandler(ContextManager contextManager) {
        this.schemaChangedHandler = new SchemaChangedHandler(contextManager);
        this.tableChangedHandler = new TableChangedHandler(contextManager);
        this.viewChangedHandler = new ViewChangedHandler(contextManager);
        this.storageUnitChangedHandler = new StorageUnitChangedHandler(contextManager);
        this.storageNodeChangedHandler = new StorageNodeChangedHandler(contextManager);
    }

    public boolean handle(String databaseName, DataChangedEvent event) {
        String eventKey = event.getKey();
        Optional schemaName = DatabaseMetaDataNodePath.findSchemaName((String)eventKey, (boolean)false);
        if (schemaName.isPresent()) {
            this.handleSchemaChanged(databaseName, (String)schemaName.get(), event);
            return true;
        }
        schemaName = DatabaseMetaDataNodePath.findSchemaName((String)eventKey, (boolean)true);
        if (schemaName.isPresent() && this.isTableMetaDataChanged(eventKey)) {
            this.handleTableChanged(databaseName, (String)schemaName.get(), event);
            return true;
        }
        if (schemaName.isPresent() && this.isViewMetaDataChanged(eventKey)) {
            this.handleViewChanged(databaseName, (String)schemaName.get(), event);
            return true;
        }
        if (DataSourceMetaDataNodePath.isDataSourceRootPath((String)eventKey)) {
            this.handleDataSourceChanged(databaseName, event);
            return true;
        }
        return false;
    }

    private void handleSchemaChanged(String databaseName, String schemaName, DataChangedEvent event) {
        if (DataChangedEvent.Type.ADDED == event.getType() || DataChangedEvent.Type.UPDATED == event.getType()) {
            this.schemaChangedHandler.handleCreated(databaseName, schemaName);
        } else if (DataChangedEvent.Type.DELETED == event.getType()) {
            this.schemaChangedHandler.handleDropped(databaseName, schemaName);
        }
    }

    private boolean isTableMetaDataChanged(String key) {
        return TableMetaDataNodePath.isTableActiveVersionPath((String)key) || TableMetaDataNodePath.isTablePath((String)key);
    }

    private void handleTableChanged(String databaseName, String schemaName, DataChangedEvent event) {
        if ((DataChangedEvent.Type.ADDED == event.getType() || DataChangedEvent.Type.UPDATED == event.getType()) && TableMetaDataNodePath.isTableActiveVersionPath((String)event.getKey())) {
            this.tableChangedHandler.handleCreatedOrAltered(databaseName, schemaName, event);
        } else if (DataChangedEvent.Type.DELETED == event.getType() && TableMetaDataNodePath.isTablePath((String)event.getKey())) {
            this.tableChangedHandler.handleDropped(databaseName, schemaName, event);
        }
    }

    private boolean isViewMetaDataChanged(String key) {
        return ViewMetaDataNodePath.isViewActiveVersionPath((String)key) || ViewMetaDataNodePath.isViewPath((String)key);
    }

    private void handleViewChanged(String databaseName, String schemaName, DataChangedEvent event) {
        if ((DataChangedEvent.Type.ADDED == event.getType() || DataChangedEvent.Type.UPDATED == event.getType()) && ViewMetaDataNodePath.isViewActiveVersionPath((String)event.getKey())) {
            this.viewChangedHandler.handleCreatedOrAltered(databaseName, schemaName, event);
        } else if (DataChangedEvent.Type.DELETED == event.getType() && ViewMetaDataNodePath.isViewPath((String)event.getKey())) {
            this.viewChangedHandler.handleDropped(databaseName, schemaName, event);
        }
    }

    private void handleDataSourceChanged(String databaseName, DataChangedEvent event) {
        Optional storageUnitName = DataSourceMetaDataNodePath.findStorageUnitNameByActiveVersionPath((String)event.getKey());
        boolean isActiveVersion = true;
        if (!storageUnitName.isPresent()) {
            storageUnitName = DataSourceMetaDataNodePath.findStorageUnitNameByStorageUnitPath((String)event.getKey());
            isActiveVersion = false;
        }
        if (storageUnitName.isPresent()) {
            this.handleStorageUnitChanged(databaseName, event, (String)storageUnitName.get(), isActiveVersion);
            return;
        }
        Optional storageNodeName = DataSourceMetaDataNodePath.findStorageNodeNameByActiveVersionPath((String)event.getKey());
        isActiveVersion = true;
        if (!storageNodeName.isPresent()) {
            storageNodeName = DataSourceMetaDataNodePath.findStorageNodeNameByStorageNodePath((String)event.getKey());
            isActiveVersion = false;
        }
        if (storageNodeName.isPresent()) {
            this.handleStorageNodeChanged(databaseName, event, (String)storageNodeName.get(), isActiveVersion);
        }
    }

    private void handleStorageUnitChanged(String databaseName, DataChangedEvent event, String storageUnitName, boolean isActiveVersion) {
        if (isActiveVersion) {
            if (DataChangedEvent.Type.ADDED == event.getType()) {
                this.storageUnitChangedHandler.handleRegistered(databaseName, storageUnitName, event);
            } else if (DataChangedEvent.Type.UPDATED == event.getType()) {
                this.storageUnitChangedHandler.handleAltered(databaseName, storageUnitName, event);
            }
            return;
        }
        if (DataChangedEvent.Type.DELETED == event.getType()) {
            this.storageUnitChangedHandler.handleUnregistered(databaseName, storageUnitName);
        }
    }

    private void handleStorageNodeChanged(String databaseName, DataChangedEvent event, String storageNodeName, boolean isActiveVersion) {
        if (isActiveVersion) {
            if (DataChangedEvent.Type.ADDED == event.getType()) {
                this.storageNodeChangedHandler.handleRegistered(databaseName, storageNodeName, event);
            } else if (DataChangedEvent.Type.UPDATED == event.getType()) {
                this.storageNodeChangedHandler.handleAltered(databaseName, storageNodeName, event);
            }
            return;
        }
        if (DataChangedEvent.Type.DELETED == event.getType()) {
            this.storageNodeChangedHandler.handleUnregistered(databaseName, storageNodeName);
        }
    }
}

