/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.SQLRouter;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.route.lifecycle.DecorateSQLRouter;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.shadow.route.retriever.ShadowDataSourceMappingsRetrieverFactory;
import org.apache.shardingsphere.shadow.rule.ShadowRule;

public final class ShadowSQLRouter
implements DecorateSQLRouter<ShadowRule> {
    public void decorateRouteContext(RouteContext routeContext, QueryContext queryContext, ShardingSphereDatabase database, ShadowRule rule, Collection<String> tableNames, ConfigurationProperties props) {
        LinkedList<RouteUnit> toBeRemovedRouteUnit = new LinkedList<RouteUnit>();
        LinkedList<RouteUnit> toBeAddedRouteUnit = new LinkedList<RouteUnit>();
        Map<String, String> shadowDataSourceMappings = ShadowDataSourceMappingsRetrieverFactory.newInstance(queryContext).retrieve(rule);
        for (RouteUnit each : routeContext.getRouteUnits()) {
            String logicName = each.getDataSourceMapper().getLogicName();
            String actualName = each.getDataSourceMapper().getActualName();
            Optional<String> productionDataSourceName = rule.findProductionDataSourceName(actualName);
            if (!productionDataSourceName.isPresent()) continue;
            String shadowDataSourceName = shadowDataSourceMappings.get(productionDataSourceName.get());
            toBeRemovedRouteUnit.add(each);
            String dataSourceName = null == shadowDataSourceName ? productionDataSourceName.get() : shadowDataSourceName;
            toBeAddedRouteUnit.add(new RouteUnit(new RouteMapper(logicName, dataSourceName), each.getTableMappers()));
        }
        routeContext.getRouteUnits().removeAll(toBeRemovedRouteUnit);
        routeContext.getRouteUnits().addAll(toBeAddedRouteUnit);
    }

    public SQLRouter.Type getType() {
        return SQLRouter.Type.DATA_SOURCE;
    }

    public int getOrder() {
        return 55;
    }

    public Class<ShadowRule> getTypeClass() {
        return ShadowRule.class;
    }
}

