/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.spi.type.ordered;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPI;
import org.apache.shardingsphere.infra.spi.type.ordered.cache.OrderedServicesCache;

public final class OrderedSPILoader {
    public static <T extends OrderedSPI<?>> Map<Class<?>, T> getServicesByClass(Class<T> serviceInterface, Collection<Class<?>> types) {
        Collection<OrderedSPI> services = OrderedSPILoader.getServices(serviceInterface);
        LinkedHashMap result = new LinkedHashMap(services.size(), 1.0f);
        for (OrderedSPI each : services) {
            types.stream().filter(type -> each.getTypeClass() == type).forEach(type -> result.put(type, each));
        }
        return result;
    }

    public static <K, V extends OrderedSPI<?>> Map<K, V> getServices(Class<V> serviceInterface, Collection<K> types) {
        return OrderedSPILoader.getServices(serviceInterface, types, Comparator.naturalOrder());
    }

    public static <K, V extends OrderedSPI<?>> Map<K, V> getServices(Class<V> serviceInterface, Collection<K> types, Comparator<Integer> orderComparator) {
        Optional<Map> cachedServices = OrderedServicesCache.findCachedServices(serviceInterface, types).map(optional -> optional);
        if (cachedServices.isPresent()) {
            return cachedServices.get();
        }
        Collection<OrderedSPI> services = OrderedSPILoader.getServices(serviceInterface, orderComparator);
        LinkedHashMap result = new LinkedHashMap(services.size(), 1.0f);
        for (OrderedSPI each : services) {
            types.stream().filter(type -> each.getTypeClass() == type.getClass()).forEach(type -> result.put(type, each));
        }
        OrderedServicesCache.cacheServices(serviceInterface, types, result);
        return result;
    }

    public static <T extends OrderedSPI<?>> Collection<T> getServices(Class<T> serviceInterface) {
        return OrderedSPILoader.getServices(serviceInterface, Comparator.naturalOrder());
    }

    private static <T extends OrderedSPI<?>> Collection<T> getServices(Class<T> serviceInterface, Comparator<Integer> comparator) {
        TreeMap<Integer, OrderedSPI> result = new TreeMap<Integer, OrderedSPI>(comparator);
        for (OrderedSPI each : ShardingSphereServiceLoader.getServiceInstances(serviceInterface)) {
            Preconditions.checkArgument((!result.containsKey(each.getOrder()) ? 1 : 0) != 0, (String)"Found same order `%s` with `%s` and `%s`", (Object)each.getOrder(), result.get(each.getOrder()), (Object)each);
            result.put(each.getOrder(), each);
        }
        return result.values();
    }

    @Generated
    private OrderedSPILoader() {
    }
}

