/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.core.metadata.database.datatype;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.database.datatype.DataTypeLoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.wrapper.SQLWrapperException;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataTypeRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataTypeRegistry.class);
    private static final Map<String, Map<String, Integer>> DATA_TYPES = new ConcurrentHashMap<String, Map<String, Integer>>();

    public static void load(DataSource dataSource, String databaseType) {
        try (Connection connection = dataSource.getConnection();){
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (!DATA_TYPES.containsKey(databaseType)) {
                DATA_TYPES.put(databaseType, (Map<String, Integer>)new CaseInsensitiveMap(new DataTypeLoader().load(databaseMetaData, (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)databaseType))));
            }
        }
        catch (SQLException ex) {
            throw new SQLWrapperException(ex);
        }
    }

    public static Optional<Integer> getDataType(String databaseType, String dataTypeName) {
        if (!DATA_TYPES.containsKey(databaseType)) {
            return Optional.empty();
        }
        if (!DATA_TYPES.get(databaseType).containsKey(dataTypeName)) {
            log.warn("Cannot find data type: {}.", (Object)dataTypeName);
            return Optional.empty();
        }
        return Optional.of(DATA_TYPES.get(databaseType).get(dataTypeName));
    }

    @Generated
    private DataTypeRegistry() {
    }
}

