/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.type.table;

import java.sql.SQLException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.metadata.refresher.MetaDataRefresher;
import org.apache.shardingsphere.mode.metadata.refresher.util.TableRefreshUtils;
import org.apache.shardingsphere.mode.persist.service.divided.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropTableStatement;

public final class DropTableStatementSchemaRefresher
implements MetaDataRefresher<DropTableStatement> {
    @Override
    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, DatabaseType databaseType, DropTableStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        Collection tableNames = sqlStatement.getTables().stream().map(each -> each.getTableName().getIdentifier().getValue()).collect(Collectors.toList());
        boolean isRuleRefreshRequired = TableRefreshUtils.isRuleRefreshRequired(database.getRuleMetaData(), schemaName, sqlStatement.getTables());
        metaDataManagerPersistService.dropTables(database.getName(), schemaName, tableNames);
        for (SimpleTableSegment each2 : sqlStatement.getTables()) {
            if (!isRuleRefreshRequired || !TableRefreshUtils.isSingleTable(each2.getTableName().getIdentifier().getValue(), database)) continue;
            metaDataManagerPersistService.alterSingleRuleConfiguration(database.getName(), database.getRuleMetaData().getConfigurations());
            break;
        }
    }

    @Override
    public Class<DropTableStatement> getType() {
        return DropTableStatement.class;
    }
}

