/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.prepare;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.prepare.ExecutionPrepareDecorator;
import org.apache.shardingsphere.infra.executor.sql.prepare.ExecutionPrepareEngine;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;

public abstract class AbstractExecutionPrepareEngine<T>
implements ExecutionPrepareEngine<T> {
    private final int maxConnectionsSizePerQuery;
    private final Map<ShardingSphereRule, ExecutionPrepareDecorator> decorators;

    protected AbstractExecutionPrepareEngine(int maxConnectionsSizePerQuery, Collection<ShardingSphereRule> rules) {
        this.maxConnectionsSizePerQuery = maxConnectionsSizePerQuery;
        this.decorators = OrderedSPILoader.getServices(ExecutionPrepareDecorator.class, rules);
    }

    @Override
    public final ExecutionGroupContext<T> prepare(String databaseName, RouteContext routeContext, Collection<ExecutionUnit> executionUnits, ExecutionGroupReportContext reportContext) throws SQLException {
        return this.prepare(databaseName, routeContext, Collections.emptyMap(), executionUnits, reportContext);
    }

    @Override
    public final ExecutionGroupContext<T> prepare(String databaseName, RouteContext routeContext, Map<String, Integer> connectionOffsets, Collection<ExecutionUnit> executionUnits, ExecutionGroupReportContext reportContext) throws SQLException {
        LinkedList<ExecutionGroup<T>> result = new LinkedList<ExecutionGroup<T>>();
        for (Map.Entry<String, List<ExecutionUnit>> entry : this.aggregateExecutionUnitGroups(executionUnits).entrySet()) {
            String dataSourceName = entry.getKey();
            List<List<ExecutionUnit>> executionUnitGroups = this.group(entry.getValue());
            ConnectionMode connectionMode = this.maxConnectionsSizePerQuery < entry.getValue().size() ? ConnectionMode.CONNECTION_STRICTLY : ConnectionMode.MEMORY_STRICTLY;
            result.addAll(this.group(databaseName, dataSourceName, connectionOffsets.getOrDefault(dataSourceName, 0), executionUnitGroups, connectionMode));
        }
        return this.decorate(routeContext, result, reportContext);
    }

    private List<List<ExecutionUnit>> group(List<ExecutionUnit> sqlUnits) {
        int desiredPartitionSize = Math.max(0 == sqlUnits.size() % this.maxConnectionsSizePerQuery ? sqlUnits.size() / this.maxConnectionsSizePerQuery : sqlUnits.size() / this.maxConnectionsSizePerQuery + 1, 1);
        return Lists.partition(sqlUnits, (int)desiredPartitionSize);
    }

    protected abstract List<ExecutionGroup<T>> group(String var1, String var2, int var3, List<List<ExecutionUnit>> var4, ConnectionMode var5) throws SQLException;

    private Map<String, List<ExecutionUnit>> aggregateExecutionUnitGroups(Collection<ExecutionUnit> executionUnits) {
        TreeMap<String, List<ExecutionUnit>> result = new TreeMap<String, List<ExecutionUnit>>();
        for (ExecutionUnit each : executionUnits) {
            result.computeIfAbsent(each.getDataSourceName(), unused -> new LinkedList()).add(each);
        }
        return result;
    }

    private ExecutionGroupContext<T> decorate(RouteContext routeContext, Collection<ExecutionGroup<T>> executionGroups, ExecutionGroupReportContext reportContext) {
        Collection<ExecutionGroup<T>> result = executionGroups;
        for (Map.Entry<ShardingSphereRule, ExecutionPrepareDecorator> each : this.decorators.entrySet()) {
            result = each.getValue().decorate(routeContext, each.getKey(), result);
        }
        return new ExecutionGroupContext<T>(result, reportContext);
    }
}

