/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.datetime.temporal;

import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import org.apache.shardingsphere.sharding.algorithm.sharding.datetime.temporal.TemporalHandler;
import org.apache.shardingsphere.sharding.algorithm.sharding.datetime.temporal.type.LocalDateTemporalHandler;
import org.apache.shardingsphere.sharding.algorithm.sharding.datetime.temporal.type.LocalDateTimeTemporalHandler;
import org.apache.shardingsphere.sharding.algorithm.sharding.datetime.temporal.type.LocalTimeTemporalHandler;
import org.apache.shardingsphere.sharding.algorithm.sharding.datetime.temporal.type.MonthTemporalHandler;
import org.apache.shardingsphere.sharding.algorithm.sharding.datetime.temporal.type.YearMonthTemporalHandler;
import org.apache.shardingsphere.sharding.algorithm.sharding.datetime.temporal.type.YearTemporalHandler;

public final class TemporalHandlerFactory {
    public static TemporalHandler newInstance(TemporalAccessor temporal) {
        if (!temporal.isSupported(ChronoField.NANO_OF_DAY)) {
            if (temporal.isSupported(ChronoField.EPOCH_DAY)) {
                return new LocalDateTemporalHandler();
            }
            if (temporal.isSupported(ChronoField.YEAR) && temporal.isSupported(ChronoField.MONTH_OF_YEAR)) {
                return new YearMonthTemporalHandler();
            }
            if (temporal.isSupported(ChronoField.YEAR)) {
                return new YearTemporalHandler();
            }
            if (temporal.isSupported(ChronoField.MONTH_OF_YEAR)) {
                return new MonthTemporalHandler();
            }
        }
        return temporal.isSupported(ChronoField.EPOCH_DAY) ? new LocalDateTimeTemporalHandler() : new LocalTimeTemporalHandler();
    }
}

