/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.checker.sql.dml;

import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.LoadXMLStatementContext;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sharding.exception.syntax.UnsupportedShardingOperationException;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShardingLoadXmlSupportedChecker
implements SupportedSQLChecker<LoadXMLStatementContext, ShardingRule> {
    public boolean isCheck(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof LoadXMLStatementContext;
    }

    public void check(ShardingRule rule, ShardingSphereDatabase database, ShardingSphereSchema currentSchema, LoadXMLStatementContext sqlStatementContext) {
        String tableName = sqlStatementContext.getSqlStatement().getTableSegment().getTableName().getIdentifier().getValue();
        ShardingSpherePreconditions.checkState((!rule.isShardingTable(tableName) ? 1 : 0) != 0, () -> new UnsupportedShardingOperationException("LOAD XML", tableName));
    }
}

