/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.type.standard;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.hint.HintManager;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.HintShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.exception.algorithm.MismatchedShardingDataSourceRouteInfoException;
import org.apache.shardingsphere.sharding.exception.algorithm.NoShardingDatabaseRouteInfoException;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngine;
import org.apache.shardingsphere.sharding.route.strategy.ShardingStrategy;
import org.apache.shardingsphere.sharding.route.strategy.ShardingStrategyFactory;
import org.apache.shardingsphere.sharding.route.strategy.type.hint.HintShardingStrategy;
import org.apache.shardingsphere.sharding.route.strategy.type.none.NoneShardingStrategy;
import org.apache.shardingsphere.sharding.rule.BindingTableRule;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;

public final class ShardingStandardRouteEngine
implements ShardingRouteEngine {
    private final String logicTableName;
    private final ShardingConditions shardingConditions;
    private final SQLStatementContext sqlStatementContext;
    private final ConfigurationProperties props;
    private final Collection<Collection<DataNode>> originalDataNodes = new LinkedList<Collection<DataNode>>();
    private final HintValueContext hintValueContext;

    public ShardingStandardRouteEngine(String logicTableName, ShardingConditions shardingConditions, SQLStatementContext sqlStatementContext, HintValueContext hintValueContext, ConfigurationProperties props) {
        this.logicTableName = logicTableName;
        this.shardingConditions = shardingConditions;
        this.sqlStatementContext = sqlStatementContext;
        this.props = props;
        this.hintValueContext = hintValueContext;
    }

    @Override
    public RouteContext route(ShardingRule shardingRule) {
        RouteContext result = new RouteContext();
        Collection<DataNode> dataNodes = this.getDataNodes(shardingRule, shardingRule.getShardingTable(this.logicTableName));
        result.getOriginalDataNodes().addAll(this.originalDataNodes);
        for (DataNode each : dataNodes) {
            result.getRouteUnits().add(new RouteUnit(new RouteMapper(each.getDataSourceName(), each.getDataSourceName()), Collections.singleton(new RouteMapper(this.logicTableName, each.getTableName()))));
        }
        return result;
    }

    private Collection<DataNode> getDataNodes(ShardingRule shardingRule, ShardingTable shardingTable) {
        ShardingStrategy databaseShardingStrategy = this.createShardingStrategy(shardingRule.getDatabaseShardingStrategyConfiguration(shardingTable), shardingRule.getShardingAlgorithms(), shardingRule.getDefaultShardingColumn());
        ShardingStrategy tableShardingStrategy = this.createShardingStrategy(shardingRule.getTableShardingStrategyConfiguration(shardingTable), shardingRule.getShardingAlgorithms(), shardingRule.getDefaultShardingColumn());
        if (this.isRoutingByHint(shardingRule, shardingTable)) {
            return this.routeByHint(shardingTable, databaseShardingStrategy, tableShardingStrategy);
        }
        if (this.isRoutingByShardingConditions(shardingRule, shardingTable)) {
            return this.routeByShardingConditions(shardingRule, shardingTable, databaseShardingStrategy, tableShardingStrategy);
        }
        return this.routeByMixedConditions(shardingRule, shardingTable, databaseShardingStrategy, tableShardingStrategy);
    }

    private boolean isRoutingByHint(ShardingRule shardingRule, ShardingTable shardingTable) {
        return shardingRule.getDatabaseShardingStrategyConfiguration(shardingTable) instanceof HintShardingStrategyConfiguration && shardingRule.getTableShardingStrategyConfiguration(shardingTable) instanceof HintShardingStrategyConfiguration;
    }

    private boolean isRoutingBySQLHint() {
        Collection tableNames = ((TableAvailable)this.sqlStatementContext).getTablesContext().getTableNames();
        for (String each : tableNames) {
            if (!this.hintValueContext.containsHintShardingValue(each)) continue;
            return true;
        }
        return false;
    }

    private Collection<DataNode> routeByHint(ShardingTable shardingTable, ShardingStrategy databaseShardingStrategy, ShardingStrategy tableShardingStrategy) {
        return this.route0(shardingTable, databaseShardingStrategy, this.getDatabaseShardingValuesFromHint(), tableShardingStrategy, this.getTableShardingValuesFromHint());
    }

    private boolean isRoutingByShardingConditions(ShardingRule shardingRule, ShardingTable shardingTable) {
        return !(shardingRule.getDatabaseShardingStrategyConfiguration(shardingTable) instanceof HintShardingStrategyConfiguration) && !(shardingRule.getTableShardingStrategyConfiguration(shardingTable) instanceof HintShardingStrategyConfiguration);
    }

    private Collection<DataNode> routeByShardingConditions(ShardingRule shardingRule, ShardingTable shardingTable, ShardingStrategy databaseShardingStrategy, ShardingStrategy tableShardingStrategy) {
        return this.shardingConditions.getConditions().isEmpty() ? this.route0(shardingTable, databaseShardingStrategy, Collections.emptyList(), tableShardingStrategy, Collections.emptyList()) : this.routeByShardingConditionsWithCondition(shardingRule, shardingTable, databaseShardingStrategy, tableShardingStrategy);
    }

    private Collection<DataNode> routeByShardingConditionsWithCondition(ShardingRule shardingRule, ShardingTable shardingTable, ShardingStrategy databaseShardingStrategy, ShardingStrategy tableShardingStrategy) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (ShardingCondition each : this.shardingConditions.getConditions()) {
            Collection<DataNode> dataNodes = this.route0(shardingTable, databaseShardingStrategy, this.getShardingValuesFromShardingConditions(shardingRule, databaseShardingStrategy.getShardingColumns(), each), tableShardingStrategy, this.getShardingValuesFromShardingConditions(shardingRule, tableShardingStrategy.getShardingColumns(), each));
            result.addAll(dataNodes);
            this.originalDataNodes.add(dataNodes);
        }
        return result;
    }

    private Collection<DataNode> routeByMixedConditions(ShardingRule shardingRule, ShardingTable shardingTable, ShardingStrategy databaseShardingStrategy, ShardingStrategy tableShardingStrategy) {
        return this.shardingConditions.getConditions().isEmpty() ? this.routeByMixedConditionsWithHint(shardingRule, shardingTable, databaseShardingStrategy, tableShardingStrategy) : this.routeByMixedConditionsWithCondition(shardingRule, shardingTable, databaseShardingStrategy, tableShardingStrategy);
    }

    private Collection<DataNode> routeByMixedConditionsWithCondition(ShardingRule shardingRule, ShardingTable shardingTable, ShardingStrategy databaseShardingStrategy, ShardingStrategy tableShardingStrategy) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (ShardingCondition each : this.shardingConditions.getConditions()) {
            Collection<DataNode> dataNodes = this.route0(shardingTable, databaseShardingStrategy, this.getDatabaseShardingValues(shardingRule, databaseShardingStrategy, each), tableShardingStrategy, this.getTableShardingValues(shardingRule, tableShardingStrategy, each));
            result.addAll(dataNodes);
            this.originalDataNodes.add(dataNodes);
        }
        return result;
    }

    private Collection<DataNode> routeByMixedConditionsWithHint(ShardingRule shardingRule, ShardingTable shardingTable, ShardingStrategy databaseShardingStrategy, ShardingStrategy tableShardingStrategy) {
        if (shardingRule.getDatabaseShardingStrategyConfiguration(shardingTable) instanceof HintShardingStrategyConfiguration) {
            return this.route0(shardingTable, databaseShardingStrategy, this.getDatabaseShardingValuesFromHint(), tableShardingStrategy, Collections.emptyList());
        }
        return this.route0(shardingTable, databaseShardingStrategy, Collections.emptyList(), tableShardingStrategy, this.getTableShardingValuesFromHint());
    }

    private List<ShardingConditionValue> getDatabaseShardingValues(ShardingRule shardingRule, ShardingStrategy databaseShardingStrategy, ShardingCondition shardingCondition) {
        return this.isGettingShardingValuesFromHint(databaseShardingStrategy) ? this.getDatabaseShardingValuesFromHint() : this.getShardingValuesFromShardingConditions(shardingRule, databaseShardingStrategy.getShardingColumns(), shardingCondition);
    }

    private List<ShardingConditionValue> getTableShardingValues(ShardingRule shardingRule, ShardingStrategy tableShardingStrategy, ShardingCondition shardingCondition) {
        return this.isGettingShardingValuesFromHint(tableShardingStrategy) ? this.getTableShardingValuesFromHint() : this.getShardingValuesFromShardingConditions(shardingRule, tableShardingStrategy.getShardingColumns(), shardingCondition);
    }

    private boolean isGettingShardingValuesFromHint(ShardingStrategy shardingStrategy) {
        return shardingStrategy instanceof HintShardingStrategy;
    }

    private List<ShardingConditionValue> getDatabaseShardingValuesFromHint() {
        if (this.isRoutingBySQLHint()) {
            return this.getDatabaseShardingValuesFromSQLHint();
        }
        return this.getShardingConditions(HintManager.isDatabaseShardingOnly() ? HintManager.getDatabaseShardingValues() : HintManager.getDatabaseShardingValues((String)this.logicTableName));
    }

    private List<ShardingConditionValue> getDatabaseShardingValuesFromSQLHint() {
        LinkedList shardingValues = new LinkedList();
        Collection tableNames = ((TableAvailable)this.sqlStatementContext).getTablesContext().getTableNames();
        for (String each : tableNames) {
            if (!each.equals(this.logicTableName) || !this.hintValueContext.containsHintShardingDatabaseValue(each)) continue;
            shardingValues.addAll(this.hintValueContext.getHintShardingDatabaseValue(each));
        }
        return this.getShardingConditions(shardingValues);
    }

    private List<ShardingConditionValue> getTableShardingValuesFromHint() {
        if (this.isRoutingBySQLHint()) {
            return this.getTableShardingValuesFromSQLHint();
        }
        return this.getShardingConditions(HintManager.getTableShardingValues((String)this.logicTableName));
    }

    private List<ShardingConditionValue> getTableShardingValuesFromSQLHint() {
        LinkedList shardingValues = new LinkedList();
        Collection tableNames = ((TableAvailable)this.sqlStatementContext).getTablesContext().getTableNames();
        for (String each : tableNames) {
            if (!each.equals(this.logicTableName) || !this.hintValueContext.containsHintShardingTableValue(each)) continue;
            shardingValues.addAll(this.hintValueContext.getHintShardingTableValue(each));
        }
        return this.getShardingConditions(shardingValues);
    }

    private List<ShardingConditionValue> getShardingConditions(Collection<Comparable<?>> shardingValue) {
        return shardingValue.isEmpty() ? Collections.emptyList() : Collections.singletonList(new ListShardingConditionValue("", this.logicTableName, shardingValue));
    }

    private List<ShardingConditionValue> getShardingValuesFromShardingConditions(ShardingRule shardingRule, Collection<String> shardingColumns, ShardingCondition shardingCondition) {
        ArrayList<ShardingConditionValue> result = new ArrayList<ShardingConditionValue>(shardingColumns.size());
        for (ShardingConditionValue each : shardingCondition.getValues()) {
            Optional<BindingTableRule> bindingTableRule = shardingRule.findBindingTableRule(each.getTableName());
            if (!this.logicTableName.equalsIgnoreCase(each.getTableName()) && (!bindingTableRule.isPresent() || !bindingTableRule.get().hasLogicTable(this.logicTableName)) || !new CaseInsensitiveSet(shardingColumns).contains((Object)each.getColumnName())) continue;
            result.add(each);
        }
        return result;
    }

    private Collection<DataNode> route0(ShardingTable shardingTable, ShardingStrategy databaseShardingStrategy, List<ShardingConditionValue> databaseShardingValues, ShardingStrategy tableShardingStrategy, List<ShardingConditionValue> tableShardingValues) {
        Collection<String> routedDataSources = this.routeDataSources(shardingTable, databaseShardingStrategy, databaseShardingValues);
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (String each : routedDataSources) {
            result.addAll(this.routeTables(shardingTable, each, tableShardingStrategy, tableShardingValues));
        }
        return result;
    }

    private Collection<String> routeDataSources(ShardingTable shardingTable, ShardingStrategy databaseShardingStrategy, List<ShardingConditionValue> databaseShardingValues) {
        if (databaseShardingValues.isEmpty()) {
            return shardingTable.getActualDataSourceNames();
        }
        Collection<String> result = databaseShardingStrategy.doSharding(shardingTable.getActualDataSourceNames(), databaseShardingValues, shardingTable.getDataSourceDataNode(), this.props);
        ShardingSpherePreconditions.checkNotEmpty(result, NoShardingDatabaseRouteInfoException::new);
        ShardingSpherePreconditions.checkState((boolean)shardingTable.getActualDataSourceNames().containsAll(result), () -> new MismatchedShardingDataSourceRouteInfoException(result, shardingTable.getActualDataSourceNames()));
        return result;
    }

    private Collection<DataNode> routeTables(ShardingTable shardingTable, String routedDataSource, ShardingStrategy tableShardingStrategy, List<ShardingConditionValue> tableShardingValues) {
        Collection<String> availableTargetTables = shardingTable.getActualTableNames(routedDataSource);
        Collection<String> routedTables = tableShardingValues.isEmpty() ? availableTargetTables : tableShardingStrategy.doSharding(availableTargetTables, tableShardingValues, shardingTable.getTableDataNode(), this.props);
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (String each : routedTables) {
            result.add(new DataNode(routedDataSource, each));
        }
        return result;
    }

    private ShardingStrategy createShardingStrategy(ShardingStrategyConfiguration shardingStrategyConfig, Map<String, ShardingAlgorithm> shardingAlgorithms, String defaultShardingColumn) {
        return null == shardingStrategyConfig ? new NoneShardingStrategy() : ShardingStrategyFactory.newInstance(shardingStrategyConfig, shardingAlgorithms.get(shardingStrategyConfig.getShardingAlgorithmName()), defaultShardingColumn);
    }
}

