/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.expression.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.expression.ExpressionConverter;

public final class TrimFunctionConverter {
    public static Optional<SqlNode> convert(FunctionSegment segment) {
        SqlIdentifier functionName = new SqlIdentifier(segment.getFunctionName(), SqlParserPos.ZERO);
        LinkedList functions = new LinkedList();
        SqlStdOperatorTable.instance().lookupOperatorOverloads(functionName, null, SqlSyntax.FUNCTION, functions, SqlNameMatchers.withCaseSensitive((boolean)false));
        return Optional.of(new SqlBasicCall((SqlOperator)functions.iterator().next(), TrimFunctionConverter.getTrimFunctionParameters(segment.getParameters()), SqlParserPos.ZERO));
    }

    private static List<SqlNode> getTrimFunctionParameters(Collection<ExpressionSegment> sqlSegments) {
        LinkedList<SqlNode> result = new LinkedList<SqlNode>();
        if (1 == sqlSegments.size()) {
            result.add((SqlNode)SqlTrimFunction.Flag.BOTH.symbol(SqlParserPos.ZERO));
            result.add((SqlNode)SqlLiteral.createCharString((String)" ", (SqlParserPos)SqlParserPos.ZERO));
        }
        if (2 == sqlSegments.size()) {
            result.add((SqlNode)SqlTrimFunction.Flag.BOTH.symbol(SqlParserPos.ZERO));
        }
        for (ExpressionSegment each : sqlSegments) {
            ExpressionConverter.convert(each).ifPresent(result::add);
        }
        return result;
    }

    @Generated
    private TrimFunctionConverter() {
    }
}

