/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.cluster.etcd;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import io.etcd.jetcd.options.DeleteOption;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.OptionsUtil;
import io.etcd.jetcd.options.PutOption;
import io.etcd.jetcd.options.WatchOption;
import io.etcd.jetcd.support.Observers;
import io.etcd.jetcd.support.Util;
import io.etcd.jetcd.watch.WatchEvent;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.props.TypedProperties;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryConfiguration;
import org.apache.shardingsphere.mode.repository.cluster.etcd.props.EtcdProperties;
import org.apache.shardingsphere.mode.repository.cluster.etcd.props.EtcdPropertyKey;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEventListener;
import org.apache.shardingsphere.mode.repository.cluster.lock.holder.DistributedLockHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EtcdRepository
implements ClusterPersistRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EtcdRepository.class);
    private static final ExecutorService EVENT_LISTENER_EXECUTOR = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Etcd-EventListener-%d").build());
    private Client client;
    private EtcdProperties etcdProps;
    private DistributedLockHolder distributedLockHolder;

    public void init(ClusterPersistRepositoryConfiguration config, ComputeNodeInstanceContext computeNodeInstanceContext) {
        this.etcdProps = new EtcdProperties(config.getProps());
        this.client = Client.builder().endpoints((Iterable)Util.toURIs((Collection)Splitter.on((String)",").trimResults().splitToList((CharSequence)config.getServerLists()))).namespace(ByteSequence.from((String)config.getNamespace(), (Charset)StandardCharsets.UTF_8)).maxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE)).build();
        this.distributedLockHolder = new DistributedLockHolder(this.getType(), (Object)this.client, (TypedProperties)this.etcdProps);
    }

    public String query(String key) {
        List keyValues = ((GetResponse)this.client.getKVClient().get(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8)).get()).getKvs();
        return keyValues.isEmpty() ? null : ((KeyValue)keyValues.iterator().next()).getValue().toString(StandardCharsets.UTF_8);
    }

    public List<String> getChildrenKeys(String key) {
        String prefix = key + "/";
        ByteSequence prefixByteSequence = ByteSequence.from((String)prefix, (Charset)StandardCharsets.UTF_8);
        GetOption getOption = GetOption.newBuilder().isPrefix(true).withSortField(GetOption.SortTarget.KEY).withSortOrder(GetOption.SortOrder.ASCEND).build();
        List keyValues = ((GetResponse)this.client.getKVClient().get(prefixByteSequence, getOption).get()).getKvs();
        return keyValues.stream().map(each -> this.getSubNodeKeyName(prefix, each.getKey().toString(StandardCharsets.UTF_8))).distinct().collect(Collectors.toList());
    }

    public boolean isExisted(String key) {
        return false;
    }

    private String getSubNodeKeyName(String prefix, String fullPath) {
        String pathWithoutPrefix = fullPath.substring(prefix.length());
        return pathWithoutPrefix.contains("/") ? pathWithoutPrefix.substring(0, pathWithoutPrefix.indexOf("/")) : pathWithoutPrefix;
    }

    public void persist(String key, String value) {
        this.buildParentPath(key);
        this.client.getKVClient().put(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8), ByteSequence.from((String)value, (Charset)StandardCharsets.UTF_8)).get();
    }

    public void update(String key, String value) {
    }

    public void persistEphemeral(String key, String value) {
        this.buildParentPath(key);
        long leaseId = ((LeaseGrantResponse)this.client.getLeaseClient().grant(((Long)this.etcdProps.getValue(EtcdPropertyKey.TIME_TO_LIVE_SECONDS)).longValue()).get()).getID();
        this.client.getLeaseClient().keepAlive(leaseId, Observers.observer(response -> {}));
        this.client.getKVClient().put(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8), ByteSequence.from((String)value, (Charset)StandardCharsets.UTF_8), PutOption.newBuilder().withLeaseId(leaseId).build()).get();
    }

    public boolean persistExclusiveEphemeral(String key, String value) {
        this.persistEphemeral(key, value);
        return true;
    }

    private void buildParentPath(String key) throws ExecutionException, InterruptedException {
        StringBuilder parentPath = new StringBuilder();
        String[] partPath = key.split("/");
        for (int index = 1; index < partPath.length - 1; ++index) {
            parentPath.append("/");
            parentPath.append(partPath[index]);
            String path = parentPath.toString();
            List keyValues = ((GetResponse)this.client.getKVClient().get(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8)).get()).getKvs();
            if (!keyValues.isEmpty()) continue;
            this.client.getKVClient().put(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8), ByteSequence.from((String)"", (Charset)StandardCharsets.UTF_8)).get();
        }
    }

    public void delete(String key) {
        this.client.getKVClient().delete(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8), DeleteOption.newBuilder().isPrefix(true).build());
    }

    public void watch(String key, DataChangedEventListener dataChangedEventListener) {
        Watch.Listener listener = Watch.listener(response -> {
            for (WatchEvent each : response.getEvents()) {
                DataChangedEvent.Type type = this.getEventChangedType(each);
                if (DataChangedEvent.Type.IGNORED == type) continue;
                this.dispatchEvent(dataChangedEventListener, each, type);
            }
        });
        ByteSequence prefix = ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8);
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix should not be null");
        this.client.getWatchClient().watch(prefix, WatchOption.newBuilder().withRange(OptionsUtil.prefixEndOf((ByteSequence)prefix)).build(), listener);
    }

    public void removeDataListener(String key) {
    }

    private DataChangedEvent.Type getEventChangedType(WatchEvent event) {
        if (1L == event.getKeyValue().getVersion()) {
            return DataChangedEvent.Type.ADDED;
        }
        switch (event.getEventType()) {
            case PUT: {
                return DataChangedEvent.Type.UPDATED;
            }
            case DELETE: {
                return DataChangedEvent.Type.DELETED;
            }
        }
        return DataChangedEvent.Type.IGNORED;
    }

    private void dispatchEvent(DataChangedEventListener dataChangedEventListener, WatchEvent event, DataChangedEvent.Type type) {
        CompletableFuture.runAsync(() -> dataChangedEventListener.onChange(new DataChangedEvent(event.getKeyValue().getKey().toString(StandardCharsets.UTF_8), event.getKeyValue().getValue().toString(StandardCharsets.UTF_8), type)), EVENT_LISTENER_EXECUTOR).whenComplete((unused, throwable) -> {
            if (null != throwable) {
                log.error("Dispatch event failed", throwable);
            }
        });
    }

    public void close() {
        this.client.close();
        EVENT_LISTENER_EXECUTOR.shutdown();
    }

    public String getType() {
        return "etcd";
    }

    @Generated
    public DistributedLockHolder getDistributedLockHolder() {
        return this.distributedLockHolder;
    }
}

