/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.yaml.swapper;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.authority.config.AuthorityRuleConfiguration;
import org.apache.shardingsphere.authority.rule.builder.DefaultAuthorityRuleConfigurationBuilder;
import org.apache.shardingsphere.authority.yaml.config.YamlAuthorityRuleConfiguration;
import org.apache.shardingsphere.authority.yaml.swapper.YamlUserSwapper;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;

public final class YamlAuthorityRuleConfigurationSwapper
implements YamlRuleConfigurationSwapper<YamlAuthorityRuleConfiguration, AuthorityRuleConfiguration> {
    private final YamlUserSwapper userSwapper = new YamlUserSwapper();
    private final YamlAlgorithmConfigurationSwapper algorithmSwapper = new YamlAlgorithmConfigurationSwapper();

    public YamlAuthorityRuleConfiguration swapToYamlConfiguration(AuthorityRuleConfiguration data) {
        YamlAuthorityRuleConfiguration result = new YamlAuthorityRuleConfiguration();
        result.setPrivilege(this.algorithmSwapper.swapToYamlConfiguration(data.getPrivilegeProvider()));
        result.setUsers(data.getUsers().stream().map(this.userSwapper::swapToYamlConfiguration).collect(Collectors.toList()));
        result.setDefaultAuthenticator(data.getDefaultAuthenticator());
        data.getAuthenticators().forEach((key, value) -> result.getAuthenticators().put((String)key, this.algorithmSwapper.swapToYamlConfiguration(value)));
        return result;
    }

    public AuthorityRuleConfiguration swapToObject(YamlAuthorityRuleConfiguration yamlConfig) {
        Collection users = yamlConfig.getUsers().stream().map(this.userSwapper::swapToObject).collect(Collectors.toList());
        AlgorithmConfiguration provider = this.algorithmSwapper.swapToObject(yamlConfig.getPrivilege());
        if (null == provider) {
            provider = new DefaultAuthorityRuleConfigurationBuilder().build().getPrivilegeProvider();
        }
        Map<String, AlgorithmConfiguration> authenticators = yamlConfig.getAuthenticators().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.algorithmSwapper.swapToObject((YamlAlgorithmConfiguration)entry.getValue())));
        return new AuthorityRuleConfiguration(users, provider, authenticators, yamlConfig.getDefaultAuthenticator());
    }

    public Class<AuthorityRuleConfiguration> getTypeClass() {
        return AuthorityRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "AUTHORITY";
    }

    public int getOrder() {
        return 500;
    }
}

