/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.route.engine.tableless;

import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.CloseStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.CursorAvailable;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.engine.tableless.TablelessRouteEngine;
import org.apache.shardingsphere.infra.route.engine.tableless.type.broadcast.TablelessDataSourceBroadcastRouteEngine;
import org.apache.shardingsphere.infra.route.engine.tableless.type.broadcast.TablelessInstanceBroadcastRouteEngine;
import org.apache.shardingsphere.infra.route.engine.tableless.type.ignore.TablelessIgnoreRouteEngine;
import org.apache.shardingsphere.infra.route.engine.tableless.type.unicast.TablelessDataSourceUnicastRouteEngine;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.AlterResourceGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.CreateResourceGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.DropResourceGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.LoadStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.ResetParameterStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.SetResourceGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.ShowDatabasesStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.ShowTableStatusStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.ShowTablesStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.AlterFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.AlterSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.AlterTablespaceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateTablespaceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropTablespaceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.DMLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.tcl.TCLStatement;

public final class TablelessRouteEngineFactory {
    public static TablelessRouteEngine newInstance(QueryContext queryContext, ShardingSphereDatabase database) {
        SQLStatement sqlStatement = queryContext.getSqlStatementContext().getSqlStatement();
        if (sqlStatement instanceof DALStatement) {
            return TablelessRouteEngineFactory.getDALRouteEngine(sqlStatement, database);
        }
        if (sqlStatement instanceof TCLStatement) {
            return new TablelessDataSourceBroadcastRouteEngine();
        }
        if (sqlStatement instanceof DDLStatement) {
            return TablelessRouteEngineFactory.getDDLRouteEngine(queryContext.getSqlStatementContext(), database);
        }
        if (sqlStatement instanceof DMLStatement) {
            return TablelessRouteEngineFactory.getDMLRouteEngine(queryContext.getSqlStatementContext(), queryContext.getConnectionContext());
        }
        return new TablelessIgnoreRouteEngine();
    }

    private static TablelessRouteEngine getDALRouteEngine(SQLStatement sqlStatement, ShardingSphereDatabase database) {
        if (sqlStatement instanceof ShowTablesStatement || sqlStatement instanceof ShowTableStatusStatement || sqlStatement instanceof SetStatement) {
            return new TablelessDataSourceBroadcastRouteEngine();
        }
        if (sqlStatement instanceof ResetParameterStatement || sqlStatement instanceof ShowDatabasesStatement || sqlStatement instanceof LoadStatement) {
            return new TablelessDataSourceBroadcastRouteEngine();
        }
        if (TablelessRouteEngineFactory.isResourceGroupStatement(sqlStatement)) {
            return new TablelessInstanceBroadcastRouteEngine(database);
        }
        return new TablelessIgnoreRouteEngine();
    }

    private static boolean isResourceGroupStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof CreateResourceGroupStatement || sqlStatement instanceof AlterResourceGroupStatement || sqlStatement instanceof DropResourceGroupStatement || sqlStatement instanceof SetResourceGroupStatement;
    }

    private static TablelessRouteEngine getDDLRouteEngine(SQLStatementContext sqlStatementContext, ShardingSphereDatabase database) {
        if (sqlStatementContext instanceof CursorAvailable) {
            return TablelessRouteEngineFactory.getCursorRouteEngine(sqlStatementContext, database);
        }
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (TablelessRouteEngineFactory.isFunctionDDLStatement(sqlStatement) || TablelessRouteEngineFactory.isSchemaDDLStatement(sqlStatement)) {
            return new TablelessDataSourceBroadcastRouteEngine();
        }
        return new TablelessIgnoreRouteEngine();
    }

    private static boolean isFunctionDDLStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof CreateFunctionStatement || sqlStatement instanceof AlterFunctionStatement || sqlStatement instanceof DropFunctionStatement;
    }

    private static boolean isSchemaDDLStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof CreateSchemaStatement || sqlStatement instanceof AlterSchemaStatement || sqlStatement instanceof DropSchemaStatement;
    }

    private static TablelessRouteEngine getCursorRouteEngine(SQLStatementContext sqlStatementContext, ShardingSphereDatabase database) {
        if (sqlStatementContext instanceof CloseStatementContext && ((CloseStatementContext)sqlStatementContext).getSqlStatement().isCloseAll()) {
            return new TablelessDataSourceBroadcastRouteEngine();
        }
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof CreateTablespaceStatement || sqlStatement instanceof AlterTablespaceStatement || sqlStatement instanceof DropTablespaceStatement) {
            return new TablelessInstanceBroadcastRouteEngine(database);
        }
        return new TablelessIgnoreRouteEngine();
    }

    private static TablelessRouteEngine getDMLRouteEngine(SQLStatementContext sqlStatementContext, ConnectionContext connectionContext) {
        if (sqlStatementContext instanceof SelectStatementContext) {
            return new TablelessDataSourceUnicastRouteEngine(connectionContext);
        }
        return new TablelessIgnoreRouteEngine();
    }

    @Generated
    private TablelessRouteEngineFactory() {
    }
}

