/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.route.engine.tableless.router;

import java.util.Collection;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.engine.tableless.TablelessRouteEngineFactory;
import org.apache.shardingsphere.infra.rule.attribute.datasource.aggregate.AggregatedDataSourceRuleAttribute;
import org.apache.shardingsphere.infra.session.query.QueryContext;

public final class TablelessSQLRouter {
    public RouteContext route(QueryContext queryContext, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, Collection<String> tableNames, RouteContext routeContext) {
        if (tableNames.isEmpty() && routeContext.getRouteUnits().isEmpty()) {
            Collection<String> aggregatedDataSources = this.getAggregatedDataSources(database);
            return TablelessRouteEngineFactory.newInstance(queryContext, database).route(globalRuleMetaData, aggregatedDataSources);
        }
        return routeContext;
    }

    private Collection<String> getAggregatedDataSources(ShardingSphereDatabase database) {
        Collection attributes = database.getRuleMetaData().getAttributes(AggregatedDataSourceRuleAttribute.class);
        ShardingSpherePreconditions.checkNotEmpty((Collection)attributes, () -> new UnsupportedOperationException("Can not find aggregated data source"));
        return ((AggregatedDataSourceRuleAttribute)attributes.iterator().next()).getAggregatedDataSources().keySet();
    }
}

