/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.dal;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.ExplainStatement;

public final class ExplainStatementContext
extends CommonSQLStatementContext
implements TableAvailable {
    private final TablesContext tablesContext;

    public ExplainStatementContext(ExplainStatement sqlStatement) {
        super((SQLStatement)sqlStatement);
        this.tablesContext = new TablesContext(this.extractTablesFromExplain(sqlStatement));
    }

    private Collection<SimpleTableSegment> extractTablesFromExplain(ExplainStatement sqlStatement) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        sqlStatement.getSimpleTable().ifPresent(result::add);
        SQLStatement explainableStatement = sqlStatement.getSqlStatement().orElse(null);
        TableExtractor extractor = new TableExtractor();
        extractor.extractTablesFromSQLStatement(explainableStatement);
        result.addAll(extractor.getRewriteTables());
        return result;
    }

    public ExplainStatement getSqlStatement() {
        return (ExplainStatement)super.getSqlStatement();
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

