/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.spi.type.ordered.cache;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public final class OrderedServicesCache {
    private static volatile SoftReference<Map<Key, Map<?, ?>>> cache = new SoftReference(new ConcurrentHashMap(128, 1.0f));

    public static Optional<Map<?, ?>> findCachedServices(Class<?> spiClass, Collection<?> types) {
        return Optional.ofNullable(cache.get()).map(optional -> (Map)optional.get(new Key(spiClass, types)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void cacheServices(Class<?> spiClass, Collection<?> types, Map<?, ?> services) {
        Map<Key, Map<?, ?>> cache = OrderedServicesCache.cache.get();
        if (null == cache) {
            Class<OrderedServicesCache> clazz = OrderedServicesCache.class;
            // MONITORENTER : org.apache.shardingsphere.infra.spi.type.ordered.cache.OrderedServicesCache.class
            cache = OrderedServicesCache.cache.get();
            if (null == cache) {
                cache = new ConcurrentHashMap(128, 1.0f);
                OrderedServicesCache.cache = new SoftReference(cache);
            }
            // MONITOREXIT : clazz
        }
        cache.put(new Key(spiClass, types), services);
    }

    public static void clearCache() {
        Map<Key, Map<?, ?>> cache = OrderedServicesCache.cache.get();
        if (null != cache) {
            cache.clear();
        }
    }

    @Generated
    private OrderedServicesCache() {
    }

    private static final class Key {
        private final Class<?> clazz;
        private final Collection<?> types;

        @Generated
        public Key(Class<?> clazz, Collection<?> types) {
            this.clazz = clazz;
            this.types = types;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            Class<?> this$clazz = this.clazz;
            Class<?> other$clazz = other.clazz;
            if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
                return false;
            }
            Collection<?> this$types = this.types;
            Collection<?> other$types = other.types;
            return !(this$types == null ? other$types != null : !((Object)this$types).equals(other$types));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $clazz = this.clazz;
            result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
            Collection<?> $types = this.types;
            result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
            return result;
        }
    }
}

