/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerAvailable;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.PivotSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.IndexHintSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class SimpleTableSegment
implements TableSegment,
OwnerAvailable {
    private final TableNameSegment tableName;
    private OwnerSegment owner;
    private AliasSegment alias;
    private final Collection<IndexHintSegment> indexHintSegments = new LinkedList<IndexHintSegment>();
    private PivotSegment pivot;
    private IdentifierValue dbLink;
    private IdentifierValue at;

    @Override
    public int getStartIndex() {
        if (null == this.owner) {
            return this.tableName.getStartIndex();
        }
        return this.owner.getOwner().isPresent() ? this.owner.getOwner().get().getStartIndex() : this.owner.getStartIndex();
    }

    @Override
    public int getStopIndex() {
        return null == this.alias ? this.tableName.getStopIndex() : this.alias.getStopIndex();
    }

    @Override
    public Optional<OwnerSegment> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    public Optional<IdentifierValue> getDbLink() {
        return Optional.ofNullable(this.dbLink);
    }

    public Optional<IdentifierValue> getAt() {
        return Optional.ofNullable(this.at);
    }

    @Override
    public Optional<String> getAliasName() {
        return null == this.alias ? Optional.empty() : Optional.ofNullable(this.alias.getIdentifier().getValue());
    }

    @Override
    public Optional<IdentifierValue> getAlias() {
        return Optional.ofNullable(this.alias).map(AliasSegment::getIdentifier);
    }

    public Optional<AliasSegment> getAliasSegment() {
        return Optional.ofNullable(this.alias);
    }

    public Optional<PivotSegment> getPivot() {
        return Optional.ofNullable(this.pivot);
    }

    @Generated
    public SimpleTableSegment(TableNameSegment tableName) {
        this.tableName = tableName;
    }

    @Generated
    public TableNameSegment getTableName() {
        return this.tableName;
    }

    @Generated
    public Collection<IndexHintSegment> getIndexHintSegments() {
        return this.indexHintSegments;
    }

    @Override
    @Generated
    public void setOwner(OwnerSegment owner) {
        this.owner = owner;
    }

    @Override
    @Generated
    public void setAlias(AliasSegment alias) {
        this.alias = alias;
    }

    @Generated
    public void setPivot(PivotSegment pivot) {
        this.pivot = pivot;
    }

    @Generated
    public void setDbLink(IdentifierValue dbLink) {
        this.dbLink = dbLink;
    }

    @Generated
    public void setAt(IdentifierValue at) {
        this.at = at;
    }
}

