/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa.jta.connection.dialect;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.shardingsphere.transaction.xa.jta.connection.XAConnectionWrapper;

public final class MySQLXAConnectionWrapper
implements XAConnectionWrapper {
    private Class<Connection> jdbcConnectionClass;
    private Method xaConnectionCreatorMethod;

    @Override
    public XAConnection wrap(XADataSource xaDataSource, Connection connection) throws SQLException {
        return this.createXAConnection(xaDataSource, connection.unwrap(this.jdbcConnectionClass));
    }

    public void init(Properties props) {
        this.loadReflection();
    }

    private void loadReflection() {
        this.jdbcConnectionClass = this.getJDBCConnectionClass();
        this.xaConnectionCreatorMethod = this.getXAConnectionCreatorMethod();
    }

    private Class<Connection> getJDBCConnectionClass() {
        try {
            return Class.forName("com.mysql.jdbc.Connection");
        }
        catch (ClassNotFoundException ignored) {
            return Class.forName("com.mysql.cj.jdbc.JdbcConnection");
        }
    }

    private Method getXAConnectionCreatorMethod() {
        Method result = this.getXADataSourceClass().getDeclaredMethod("wrapConnection", Connection.class);
        result.setAccessible(true);
        return result;
    }

    private Class<XADataSource> getXADataSourceClass() {
        try {
            return Class.forName("com.mysql.jdbc.jdbc2.optional.MysqlXADataSource");
        }
        catch (ClassNotFoundException ignored) {
            return Class.forName("com.mysql.cj.jdbc.MysqlXADataSource");
        }
    }

    private XAConnection createXAConnection(XADataSource xaDataSource, Connection connection) {
        return (XAConnection)this.xaConnectionCreatorMethod.invoke((Object)xaDataSource, connection);
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

