/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.DerivedColumn;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.extractor.ProjectionIdentifierExtractEngine;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.AggregationType;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public class AggregationProjection
implements Projection {
    private final AggregationType type;
    private final String expression;
    private final IdentifierValue alias;
    private final DatabaseType databaseType;
    private final String separator;
    private final List<AggregationProjection> derivedAggregationProjections = new ArrayList<AggregationProjection>(2);
    private int index = -1;

    public AggregationProjection(AggregationType type, String expression, IdentifierValue alias, DatabaseType databaseType) {
        this.type = type;
        this.expression = expression;
        this.alias = alias;
        this.databaseType = databaseType;
        this.separator = null;
    }

    public Optional<String> getSeparator() {
        return Optional.ofNullable(this.separator);
    }

    @Override
    public String getColumnName() {
        return this.getColumnLabel();
    }

    @Override
    public String getColumnLabel() {
        ProjectionIdentifierExtractEngine extractEngine = new ProjectionIdentifierExtractEngine(this.databaseType);
        return this.getAlias().isPresent() && !DerivedColumn.isDerivedColumnName(this.getAlias().get().getValueWithQuoteCharacters()) ? extractEngine.getIdentifierValue(this.getAlias().get()) : extractEngine.getColumnNameFromFunction(this.type.name(), this.expression);
    }

    @Override
    public final Optional<IdentifierValue> getAlias() {
        return Optional.ofNullable(this.alias);
    }

    @Generated
    public AggregationProjection(AggregationType type, String expression, IdentifierValue alias, DatabaseType databaseType, String separator) {
        this.type = type;
        this.expression = expression;
        this.alias = alias;
        this.databaseType = databaseType;
        this.separator = separator;
    }

    @Generated
    public AggregationType getType() {
        return this.type;
    }

    @Override
    @Generated
    public String getExpression() {
        return this.expression;
    }

    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public List<AggregationProjection> getDerivedAggregationProjections() {
        return this.derivedAggregationProjections;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregationProjection)) {
            return false;
        }
        AggregationProjection other = (AggregationProjection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        AggregationType this$type = this.getType();
        AggregationType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        Optional<IdentifierValue> this$alias = this.getAlias();
        Optional<IdentifierValue> other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !((Object)this$alias).equals(other$alias)) {
            return false;
        }
        DatabaseType this$databaseType = this.getDatabaseType();
        DatabaseType other$databaseType = other.getDatabaseType();
        if (this$databaseType == null ? other$databaseType != null : !this$databaseType.equals(other$databaseType)) {
            return false;
        }
        Optional<String> this$separator = this.getSeparator();
        Optional<String> other$separator = other.getSeparator();
        if (this$separator == null ? other$separator != null : !((Object)this$separator).equals(other$separator)) {
            return false;
        }
        List<AggregationProjection> this$derivedAggregationProjections = this.getDerivedAggregationProjections();
        List<AggregationProjection> other$derivedAggregationProjections = other.getDerivedAggregationProjections();
        return !(this$derivedAggregationProjections == null ? other$derivedAggregationProjections != null : !((Object)this$derivedAggregationProjections).equals(other$derivedAggregationProjections));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AggregationProjection;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        AggregationType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        Optional<IdentifierValue> $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : ((Object)$alias).hashCode());
        DatabaseType $databaseType = this.getDatabaseType();
        result = result * 59 + ($databaseType == null ? 43 : $databaseType.hashCode());
        Optional<String> $separator = this.getSeparator();
        result = result * 59 + ($separator == null ? 43 : ((Object)$separator).hashCode());
        List<AggregationProjection> $derivedAggregationProjections = this.getDerivedAggregationProjections();
        result = result * 59 + ($derivedAggregationProjections == null ? 43 : ((Object)$derivedAggregationProjections).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AggregationProjection(type=" + this.getType() + ", expression=" + this.getExpression() + ", alias=" + this.getAlias() + ", databaseType=" + this.getDatabaseType() + ", separator=" + this.getSeparator() + ", derivedAggregationProjections=" + this.getDerivedAggregationProjections() + ", index=" + this.getIndex() + ")";
    }

    @Generated
    public void setIndex(int index) {
        this.index = index;
    }
}

