/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.type;

import lombok.Generated;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.dal.OptimizeTableStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.dal.ShowColumnsStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.dal.ShowCreateTableStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.dal.ShowIndexStatementBinder;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.OptimizeTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.ShowColumnsStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.ShowCreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.ShowIndexStatement;

public final class DALStatementBindEngine {
    private final ShardingSphereMetaData metaData;
    private final String currentDatabaseName;
    private final HintValueContext hintValueContext;

    public DALStatement bind(DALStatement statement) {
        SQLStatementBinderContext binderContext = new SQLStatementBinderContext(this.metaData, this.currentDatabaseName, this.hintValueContext, (SQLStatement)statement);
        if (statement instanceof OptimizeTableStatement) {
            return new OptimizeTableStatementBinder().bind((OptimizeTableStatement)statement, binderContext);
        }
        if (statement instanceof ShowCreateTableStatement) {
            return new ShowCreateTableStatementBinder().bind((ShowCreateTableStatement)statement, binderContext);
        }
        if (statement instanceof ShowColumnsStatement) {
            return new ShowColumnsStatementBinder().bind((ShowColumnsStatement)statement, binderContext);
        }
        if (statement instanceof ShowIndexStatement) {
            return new ShowIndexStatementBinder().bind((ShowIndexStatement)statement, binderContext);
        }
        return statement;
    }

    @Generated
    public DALStatementBindEngine(ShardingSphereMetaData metaData, String currentDatabaseName, HintValueContext hintValueContext) {
        this.metaData = metaData;
        this.currentDatabaseName = currentDatabaseName;
        this.hintValueContext = hintValueContext;
    }
}

