/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge.dql;

import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.exception.data.DecryptFailedException;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.core.external.sql.identifier.SQLExceptionIdentifier;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;

public final class EncryptMergedResult
implements MergedResult {
    private final ShardingSphereDatabase database;
    private final ShardingSphereMetaData metaData;
    private final SelectStatementContext selectStatementContext;
    private final MergedResult mergedResult;

    public boolean next() throws SQLException {
        return this.mergedResult.next();
    }

    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        Optional columnProjection = this.selectStatementContext.findColumnProjection(columnIndex);
        if (!columnProjection.isPresent()) {
            return this.mergedResult.getValue(columnIndex, type);
        }
        String originalTableName = ((ColumnProjection)columnProjection.get()).getOriginalTable().getValue();
        String originalColumnName = ((ColumnProjection)columnProjection.get()).getOriginalColumn().getValue();
        ShardingSphereDatabase database = this.metaData.containsDatabase(((ColumnProjection)columnProjection.get()).getColumnBoundInfo().getOriginalDatabase().getValue()) ? this.metaData.getDatabase(((ColumnProjection)columnProjection.get()).getColumnBoundInfo().getOriginalDatabase().getValue()) : this.database;
        Optional rule = database.getRuleMetaData().findSingleRule(EncryptRule.class);
        if (!rule.isPresent() || !((EncryptRule)rule.get()).findEncryptTable(originalTableName).map(optional -> optional.isEncryptColumn(originalColumnName)).orElse(false).booleanValue()) {
            return this.mergedResult.getValue(columnIndex, type);
        }
        Object cipherValue = this.mergedResult.getValue(columnIndex, Object.class);
        EncryptColumn encryptColumn = ((EncryptRule)rule.get()).getEncryptTable(originalTableName).getEncryptColumn(originalColumnName);
        String schemaName = this.selectStatementContext.getTablesContext().getSchemaName().orElseGet(() -> new DatabaseTypeRegistry(this.selectStatementContext.getDatabaseType()).getDefaultSchemaName(database.getName()));
        try {
            return encryptColumn.getCipher().decrypt(database.getName(), schemaName, originalTableName, originalColumnName, cipherValue);
        }
        catch (Exception ex) {
            throw new DecryptFailedException(String.valueOf(cipherValue), new SQLExceptionIdentifier(database.getName(), originalTableName, originalColumnName), ex);
        }
    }

    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) throws SQLException {
        return this.mergedResult.getCalendarValue(columnIndex, type, calendar);
    }

    public InputStream getInputStream(int columnIndex, String type) throws SQLException {
        return this.mergedResult.getInputStream(columnIndex, type);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.mergedResult.getCharacterStream(columnIndex);
    }

    public boolean wasNull() throws SQLException {
        return this.mergedResult.wasNull();
    }

    @Generated
    public EncryptMergedResult(ShardingSphereDatabase database, ShardingSphereMetaData metaData, SelectStatementContext selectStatementContext, MergedResult mergedResult) {
        this.database = database;
        this.metaData = metaData;
        this.selectStatementContext = selectStatementContext;
        this.mergedResult = mergedResult;
    }
}

