/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.comparator;

import java.util.Collection;
import java.util.Iterator;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.token.comparator.EncryptorComparator;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ExpressionProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ParameterMarkerProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.SubqueryProjection;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.ColumnSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class InsertSelectColumnsEncryptorComparator {
    public static boolean isSame(Collection<ColumnSegment> insertColumns, Collection<Projection> projections, EncryptRule encryptRule) {
        Iterator<ColumnSegment> insertColumnsIterator = insertColumns.iterator();
        Iterator<Projection> projectionIterator = projections.iterator();
        while (insertColumnsIterator.hasNext()) {
            ColumnSegmentBoundInfo projectionColumnBoundInfo;
            EncryptAlgorithm projectionEncryptor;
            ColumnSegment insertColumnSegment = insertColumnsIterator.next();
            EncryptAlgorithm insertColumnEncryptor = encryptRule.findQueryEncryptor(insertColumnSegment.getColumnBoundInfo().getOriginalTable().getValue(), insertColumnSegment.getColumnBoundInfo().getOriginalColumn().getValue()).orElse(null);
            Projection projection = projectionIterator.next();
            if (InsertSelectColumnsEncryptorComparator.isLiteralOrParameterMarker(projection) || EncryptorComparator.isSame(insertColumnEncryptor, projectionEncryptor = (EncryptAlgorithm)encryptRule.findQueryEncryptor((projectionColumnBoundInfo = InsertSelectColumnsEncryptorComparator.getColumnSegmentBoundInfo(projection)).getOriginalTable().getValue(), projectionColumnBoundInfo.getOriginalColumn().getValue()).orElse(null))) continue;
            return false;
        }
        return true;
    }

    private static boolean isLiteralOrParameterMarker(Projection projection) {
        if (projection instanceof ExpressionProjection) {
            ExpressionSegment expressionSegment = ((ExpressionProjection)projection).getExpressionSegment().getExpr();
            return expressionSegment instanceof LiteralExpressionSegment;
        }
        return projection instanceof ParameterMarkerProjection;
    }

    private static ColumnSegmentBoundInfo getColumnSegmentBoundInfo(Projection projection) {
        if (projection instanceof ColumnProjection) {
            return ((ColumnProjection)projection).getColumnBoundInfo();
        }
        if (projection instanceof SubqueryProjection) {
            return InsertSelectColumnsEncryptorComparator.getColumnSegmentBoundInfo(((SubqueryProjection)projection).getProjection());
        }
        return new ColumnSegmentBoundInfo(new IdentifierValue(projection.getColumnLabel()));
    }

    @Generated
    private InsertSelectColumnsEncryptorComparator() {
    }
}

