/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.proxy.exception.DatabaseServerLoadingException;

public final class DatabaseServerInfo {
    private final String databaseType;
    private final String databaseVersion;

    public DatabaseServerInfo(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            this.databaseType = databaseMetaData.getDatabaseProductName();
            this.databaseVersion = databaseMetaData.getDatabaseProductVersion();
        }
        catch (SQLException ex) {
            throw new DatabaseServerLoadingException(ex);
        }
    }

    public String toString() {
        return String.format("Database type is `%s`, version is `%s`", this.databaseType, this.databaseVersion);
    }

    @Generated
    public String getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public String getDatabaseVersion() {
        return this.databaseVersion;
    }
}

