/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dal.show;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryMergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;

public class LogicTablesMergedResult
extends MemoryMergedResult<ShardingRule> {
    public LogicTablesMergedResult(ShardingRule rule, SQLStatementContext sqlStatementContext, ShardingSphereSchema schema, List<QueryResult> queryResults) throws SQLException {
        super((ShardingSphereRule)rule, schema, sqlStatementContext, queryResults);
    }

    protected final List<MemoryQueryResultRow> init(ShardingRule rule, ShardingSphereSchema schema, SQLStatementContext sqlStatementContext, List<QueryResult> queryResults) throws SQLException {
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        for (QueryResult each : queryResults) {
            while (each.next()) {
                MemoryQueryResultRow memoryResultSetRow = new MemoryQueryResultRow(each);
                String actualTableName = memoryResultSetRow.getCell(1).toString();
                Optional<ShardingTable> shardingTable = rule.findShardingTableByActualTable(actualTableName);
                if (shardingTable.isPresent()) {
                    String logicTableName = shardingTable.get().getLogicTable();
                    memoryResultSetRow.setCell(1, (Object)logicTableName);
                    this.setCellValue(memoryResultSetRow, logicTableName, actualTableName, schema.getTable(logicTableName), rule);
                    result.putIfAbsent(logicTableName, memoryResultSetRow);
                    continue;
                }
                this.setCellValue(memoryResultSetRow, actualTableName, actualTableName, schema.getTable(actualTableName), rule);
                result.putIfAbsent(actualTableName, memoryResultSetRow);
            }
        }
        return new LinkedList<MemoryQueryResultRow>(result.values());
    }

    protected void setCellValue(MemoryQueryResultRow memoryResultSetRow, String logicTableName, String actualTableName, ShardingSphereTable table, ShardingRule rule) {
    }
}

