/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.metadata.data.dialect.type;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.sharding.metadata.data.dialect.DialectShardingStatisticsTableCollector;

public final class MySQLShardingStatisticsTableCollector
implements DialectShardingStatisticsTableCollector {
    private static final String FETCH_TABLE_ROWS_AND_DATA_LENGTH_SQL = "SELECT TABLE_ROWS, DATA_LENGTH FROM information_schema.TABLES WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ?";

    @Override
    public boolean appendRow(Connection connection, DataNode dataNode, List<Object> row) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(FETCH_TABLE_ROWS_AND_DATA_LENGTH_SQL);){
            preparedStatement.setString(1, connection.getCatalog());
            preparedStatement.setString(2, dataNode.getTableName());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    row.add(resultSet.getBigDecimal("TABLE_ROWS"));
                    row.add(resultSet.getBigDecimal("DATA_LENGTH"));
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

