/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleCreateExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.InvalidRuleConfigurationException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableReferenceRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.checker.ShardingTableRuleStatementChecker;
import org.apache.shardingsphere.sharding.distsql.segment.table.TableReferenceRuleSegment;
import org.apache.shardingsphere.sharding.distsql.statement.CreateShardingTableReferenceRuleStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

@DistSQLExecutorCurrentRuleRequired(value=ShardingRule.class)
public final class CreateShardingTableReferenceRuleExecutor
implements DatabaseRuleCreateExecutor<CreateShardingTableReferenceRuleStatement, ShardingRule, ShardingRuleConfiguration> {
    private ShardingSphereDatabase database;
    private ShardingRule rule;

    public void checkBeforeUpdate(CreateShardingTableReferenceRuleStatement sqlStatement) {
        if (!sqlStatement.isIfNotExists()) {
            this.checkDuplicatedRuleNames(sqlStatement);
        }
        this.checkDuplicatedTablesInShardingTableReferenceRules(sqlStatement);
        this.checkToBeReferencedShardingTablesExisted(sqlStatement);
        this.checkShardingTableReferenceRulesValid(sqlStatement);
    }

    private void checkDuplicatedRuleNames(CreateShardingTableReferenceRuleStatement sqlStatement) {
        Collection<String> duplicatedRuleNames = this.getDuplicatedRuleNames(sqlStatement);
        ShardingSpherePreconditions.checkMustEmpty(duplicatedRuleNames, () -> new DuplicateRuleException("sharding table reference", this.database.getName(), duplicatedRuleNames));
    }

    private void checkDuplicatedTablesInShardingTableReferenceRules(CreateShardingTableReferenceRuleStatement sqlStatement) {
        Collection<String> currentReferencedTableNames = this.getReferencedTableNames();
        Collection duplicatedTableNames = sqlStatement.getTableNames().stream().filter(currentReferencedTableNames::contains).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkMustEmpty((Collection)duplicatedTableNames, () -> new DuplicateRuleException("sharding table reference", this.database.getName(), duplicatedTableNames));
    }

    private void checkToBeReferencedShardingTablesExisted(CreateShardingTableReferenceRuleStatement sqlStatement) {
        Collection<String> currentShardingTableNames = this.getCurrentShardingTableNames();
        Collection notExistedTableNames = sqlStatement.getTableNames().stream().filter(each -> !currentShardingTableNames.contains(each)).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkMustEmpty((Collection)notExistedTableNames, () -> new MissingRequiredRuleException("Sharding", this.database.getName(), notExistedTableNames));
    }

    private Collection<String> getCurrentShardingTableNames() {
        CaseInsensitiveSet result = new CaseInsensitiveSet();
        result.addAll(this.rule.getConfiguration().getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        result.addAll(this.rule.getConfiguration().getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        return result;
    }

    private void checkShardingTableReferenceRulesValid(CreateShardingTableReferenceRuleStatement sqlStatement) {
        Collection bindingTableGroups = this.buildToBeCreatedRuleConfiguration(sqlStatement).getBindingTableGroups();
        Collection names = bindingTableGroups.stream().map(ShardingTableReferenceRuleConfiguration::getName).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)ShardingTableRuleStatementChecker.isValidBindingTableGroups(bindingTableGroups, this.rule.getConfiguration()), () -> new InvalidRuleConfigurationException("sharding table", names, Collections.singleton("invalid sharding table reference.")));
    }

    private Collection<String> getReferencedTableNames() {
        return this.rule.getConfiguration().getBindingTableGroups().stream().flatMap(each -> Arrays.stream(each.getReference().split(","))).map(String::trim).collect(Collectors.toList());
    }

    public ShardingRuleConfiguration buildToBeCreatedRuleConfiguration(CreateShardingTableReferenceRuleStatement sqlStatement) {
        Collection segments = sqlStatement.getRules();
        if (sqlStatement.isIfNotExists()) {
            Collection<String> duplicatedRuleNames = this.getDuplicatedRuleNames(sqlStatement);
            segments.removeIf(each -> duplicatedRuleNames.contains(each.getName()));
        }
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        segments.forEach(each -> result.getBindingTableGroups().add(new ShardingTableReferenceRuleConfiguration(each.getName(), each.getReference())));
        return result;
    }

    private Collection<String> getDuplicatedRuleNames(CreateShardingTableReferenceRuleStatement sqlStatement) {
        Collection currentRuleNames = this.rule.getConfiguration().getBindingTableGroups().stream().map(ShardingTableReferenceRuleConfiguration::getName).collect(Collectors.toSet());
        return sqlStatement.getRules().stream().map(TableReferenceRuleSegment::getName).filter(currentRuleNames::contains).collect(Collectors.toSet());
    }

    public Class<ShardingRule> getRuleClass() {
        return ShardingRule.class;
    }

    public Class<CreateShardingTableReferenceRuleStatement> getType() {
        return CreateShardingTableReferenceRuleStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ShardingRule rule) {
        this.rule = rule;
    }
}

