/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.handler;

import com.google.common.base.Strings;
import com.google.protobuf.Message;
import io.netty.channel.Channel;
import io.netty.channel.ChannelId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.cdc.CDCJob;
import org.apache.shardingsphere.data.pipeline.cdc.CDCJobType;
import org.apache.shardingsphere.data.pipeline.cdc.api.CDCJobAPI;
import org.apache.shardingsphere.data.pipeline.cdc.api.StreamDataParameter;
import org.apache.shardingsphere.data.pipeline.cdc.config.CDCJobConfiguration;
import org.apache.shardingsphere.data.pipeline.cdc.constant.CDCSinkType;
import org.apache.shardingsphere.data.pipeline.cdc.context.CDCConnectionContext;
import org.apache.shardingsphere.data.pipeline.cdc.core.ack.CDCAckId;
import org.apache.shardingsphere.data.pipeline.cdc.core.importer.CDCImporter;
import org.apache.shardingsphere.data.pipeline.cdc.core.importer.CDCImporterManager;
import org.apache.shardingsphere.data.pipeline.cdc.core.importer.sink.PipelineCDCSocketSink;
import org.apache.shardingsphere.data.pipeline.cdc.exception.CDCExceptionWrapper;
import org.apache.shardingsphere.data.pipeline.cdc.exception.MissingRequiredStreamDataSourceException;
import org.apache.shardingsphere.data.pipeline.cdc.exception.StreamDatabaseNotFoundException;
import org.apache.shardingsphere.data.pipeline.cdc.generator.CDCResponseUtils;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.request.AckStreamingRequestBody;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.request.StreamDataRequestBody;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.response.CDCResponse;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.response.StreamDataResult;
import org.apache.shardingsphere.data.pipeline.cdc.util.CDCDataNodeUtils;
import org.apache.shardingsphere.data.pipeline.cdc.util.CDCSchemaTableUtils;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextManager;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineInternalException;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PipelineJobNotFoundException;
import org.apache.shardingsphere.data.pipeline.core.exception.param.PipelineInvalidParameterException;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJobRegistry;
import org.apache.shardingsphere.data.pipeline.core.job.api.TransmissionJobAPI;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobConfigurationManager;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CDCBackendHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CDCBackendHandler.class);
    private final CDCJobAPI jobAPI = (CDCJobAPI)TypedSPILoader.getService(TransmissionJobAPI.class, (Object)"STREAMING");
    private final PipelineJobConfigurationManager jobConfigManager = new PipelineJobConfigurationManager((PipelineJobType)new CDCJobType());

    public String getDatabaseNameByJobId(String jobId) {
        return ((CDCJobConfiguration)this.jobConfigManager.getJobConfiguration(jobId)).getDatabaseName();
    }

    public CDCResponse streamData(String requestId, StreamDataRequestBody requestBody, CDCConnectionContext connectionContext, Channel channel) {
        HashSet<String> tableNames;
        ShardingSphereDatabase database = PipelineContextManager.getProxyContext().getContextManager().getMetaDataContexts().getMetaData().getDatabase(requestBody.getDatabase());
        ShardingSpherePreconditions.checkNotNull((Object)database, () -> new CDCExceptionWrapper(requestId, (Exception)((Object)new StreamDatabaseNotFoundException(String.format("%s database is not exists", requestBody.getDatabase())))));
        HashSet<String> schemaTableNames = new HashSet<String>();
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(database.getProtocolType()).getDialectDatabaseMetaData();
        if (dialectDatabaseMetaData.isSchemaAvailable()) {
            Map<String, Set<String>> schemaTableNameMap = CDCSchemaTableUtils.parseTableExpressionWithSchema(database, requestBody.getSourceSchemaTableList());
            tableNames = (HashSet<String>)((Object)schemaTableNameMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
            schemaTableNameMap.forEach((key, value) -> value.forEach(tableName -> schemaTableNames.add(key.isEmpty() ? tableName : String.join((CharSequence)".", key, tableName))));
        } else {
            schemaTableNames.addAll(CDCSchemaTableUtils.parseTableExpressionWithoutSchema(database, requestBody.getSourceSchemaTableList().stream().map(StreamDataRequestBody.SchemaTable::getTable).collect(Collectors.toList())));
            tableNames = schemaTableNames;
        }
        ShardingSpherePreconditions.checkNotEmpty(tableNames, () -> new CDCExceptionWrapper(requestId, (Exception)((Object)new MissingRequiredStreamDataSourceException())));
        Map<String, List<DataNode>> actualDataNodesMap = CDCDataNodeUtils.buildDataNodesMap(database, tableNames);
        ShardingSpherePreconditions.checkNotEmpty(actualDataNodesMap, () -> new PipelineInvalidParameterException(String.format("Not find table %s", tableNames)));
        boolean decodeWithTx = ((DialectDatabaseMetaData)DatabaseTypedSPILoader.getService(DialectDatabaseMetaData.class, (DatabaseType)database.getProtocolType())).isSupportGlobalCSN();
        StreamDataParameter parameter = new StreamDataParameter(requestBody.getDatabase(), new ArrayList<String>(schemaTableNames), requestBody.getFull(), actualDataNodesMap, decodeWithTx);
        String jobId = this.jobAPI.create(parameter, CDCSinkType.SOCKET, new Properties());
        connectionContext.setJobId(jobId);
        this.startStreaming(jobId, connectionContext, channel);
        return CDCResponseUtils.succeed(requestId, CDCResponse.ResponseCase.STREAM_DATA_RESULT, (Message)StreamDataResult.newBuilder().setStreamingId(jobId).build());
    }

    public void startStreaming(String jobId, CDCConnectionContext connectionContext, Channel channel) {
        CDCJobConfiguration cdcJobConfig = (CDCJobConfiguration)this.jobConfigManager.getJobConfiguration(jobId);
        ShardingSpherePreconditions.checkNotNull((Object)cdcJobConfig, () -> new PipelineJobNotFoundException(jobId));
        PipelineJobRegistry.stop((String)jobId);
        ShardingSphereDatabase database = PipelineContextManager.getProxyContext().getContextManager().getMetaDataContexts().getMetaData().getDatabase(cdcJobConfig.getDatabaseName());
        this.jobAPI.start(jobId, new PipelineCDCSocketSink(channel, database, cdcJobConfig.getSchemaTableNames()));
        connectionContext.setJobId(jobId);
    }

    public void stopStreaming(String jobId, ChannelId channelId) {
        if (Strings.isNullOrEmpty((String)jobId)) {
            log.warn("job id is null or empty, ignored");
            return;
        }
        CDCJob job = (CDCJob)PipelineJobRegistry.get((String)jobId);
        if (null == job) {
            return;
        }
        if (((PipelineCDCSocketSink)job.getSink()).getChannel().id().equals(channelId)) {
            log.info("close CDC job, channel id: {}", (Object)channelId);
            PipelineJobRegistry.stop((String)jobId);
            this.jobAPI.disable(jobId);
        }
    }

    public void dropStreaming(String jobId) {
        ShardingSpherePreconditions.checkState((boolean)PipelineJobIdUtils.getElasticJobConfigurationPOJO((String)jobId).isDisabled(), () -> new PipelineInternalException("Can't drop streaming job which is active", new Object[0]));
        this.jobAPI.drop(jobId);
    }

    public void processAck(AckStreamingRequestBody requestBody) {
        CDCAckId ackId = CDCAckId.unmarshal(requestBody.getAckId());
        CDCImporter importer = CDCImporterManager.getImporter(ackId.getImporterId());
        if (null == importer) {
            log.warn("Could not find importer, ack id: {}", (Object)ackId.marshal());
            return;
        }
        importer.ack(ackId.marshal());
    }
}

