/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.DateUtilities;
import com.cedarsoftware.util.SafeSimpleDateFormat;
import com.cedarsoftware.util.StringUtilities;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class Converter {
    public static final Byte BYTE_ZERO = 0;
    public static final Byte BYTE_ONE = 1;
    public static final Short SHORT_ZERO = 0;
    public static final Short SHORT_ONE = 1;
    public static final Integer INTEGER_ZERO = 0;
    public static final Integer INTEGER_ONE = 1;
    public static final Long LONG_ZERO = 0L;
    public static final Long LONG_ONE = 1L;
    public static final Float FLOAT_ZERO = Float.valueOf(0.0f);
    public static final Float FLOAT_ONE = Float.valueOf(1.0f);
    public static final Double DOUBLE_ZERO = 0.0;
    public static final Double DOUBLE_ONE = 1.0;
    public static final BigDecimal BIG_DECIMAL_ZERO = BigDecimal.ZERO;
    public static final BigInteger BIG_INTEGER_ZERO = BigInteger.ZERO;
    private static final Map<Class<?>, Work<?>> conversion = new HashMap();
    private static final Map<Class<?>, Work<?>> conversionToString = new HashMap();

    private Converter() {
    }

    public static <T> T convert(Object fromInstance, Class<T> toType) {
        if (toType == null) {
            throw new IllegalArgumentException("Type cannot be null in Converter.convert(value, type)");
        }
        Work<?> work = conversion.get(toType);
        if (work != null) {
            return (T)work.convert(fromInstance);
        }
        throw new IllegalArgumentException("Unsupported type '" + toType.getName() + "' for conversion");
    }

    public static String convert2String(Object fromInstance) {
        if (fromInstance == null) {
            return "";
        }
        return Converter.convertToString(fromInstance);
    }

    public static String convertToString(Object fromInstance) {
        if (fromInstance == null) {
            return null;
        }
        Class<?> clazz = fromInstance.getClass();
        Work<?> work = conversionToString.get(clazz);
        if (work != null) {
            return (String)work.convert(fromInstance);
        }
        if (fromInstance instanceof Calendar) {
            return SafeSimpleDateFormat.getDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(((Calendar)fromInstance).getTime());
        }
        if (fromInstance instanceof Enum) {
            return ((Enum)fromInstance).name();
        }
        return Converter.nope(fromInstance, "String");
    }

    public static BigDecimal convert2BigDecimal(Object fromInstance) {
        if (fromInstance == null) {
            return BIG_DECIMAL_ZERO;
        }
        return Converter.convertToBigDecimal(fromInstance);
    }

    public static BigDecimal convertToBigDecimal(Object fromInstance) {
        try {
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return BigDecimal.ZERO;
                }
                return new BigDecimal(((String)fromInstance).trim());
            }
            if (fromInstance instanceof BigDecimal) {
                return (BigDecimal)fromInstance;
            }
            if (fromInstance instanceof BigInteger) {
                return new BigDecimal((BigInteger)fromInstance);
            }
            if (fromInstance instanceof Long) {
                return new BigDecimal((Long)fromInstance);
            }
            if (fromInstance instanceof AtomicLong) {
                return new BigDecimal(((AtomicLong)fromInstance).get());
            }
            if (fromInstance instanceof Number) {
                return new BigDecimal(String.valueOf(fromInstance));
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            if (fromInstance instanceof java.util.Date) {
                return new BigDecimal(((java.util.Date)fromInstance).getTime());
            }
            if (fromInstance instanceof LocalDate) {
                return new BigDecimal(Converter.localDateToMillis((LocalDate)fromInstance));
            }
            if (fromInstance instanceof LocalDateTime) {
                return new BigDecimal(Converter.localDateTimeToMillis((LocalDateTime)fromInstance));
            }
            if (fromInstance instanceof ZonedDateTime) {
                return new BigDecimal(Converter.zonedDateTimeToMillis((ZonedDateTime)fromInstance));
            }
            if (fromInstance instanceof Calendar) {
                return new BigDecimal(((Calendar)fromInstance).getTime().getTime());
            }
            if (fromInstance instanceof Character) {
                return new BigDecimal(((Character)fromInstance).charValue());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'BigDecimal'", e);
        }
        Converter.nope(fromInstance, "BigDecimal");
        return null;
    }

    public static BigInteger convert2BigInteger(Object fromInstance) {
        if (fromInstance == null) {
            return BIG_INTEGER_ZERO;
        }
        return Converter.convertToBigInteger(fromInstance);
    }

    public static BigInteger convertToBigInteger(Object fromInstance) {
        try {
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return BigInteger.ZERO;
                }
                return new BigInteger(((String)fromInstance).trim());
            }
            if (fromInstance instanceof BigInteger) {
                return (BigInteger)fromInstance;
            }
            if (fromInstance instanceof BigDecimal) {
                return ((BigDecimal)fromInstance).toBigInteger();
            }
            if (fromInstance instanceof Number) {
                return new BigInteger(Long.toString(((Number)fromInstance).longValue()));
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? BigInteger.ONE : BigInteger.ZERO;
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? BigInteger.ONE : BigInteger.ZERO;
            }
            if (fromInstance instanceof java.util.Date) {
                return new BigInteger(Long.toString(((java.util.Date)fromInstance).getTime()));
            }
            if (fromInstance instanceof LocalDate) {
                return BigInteger.valueOf(Converter.localDateToMillis((LocalDate)fromInstance));
            }
            if (fromInstance instanceof LocalDateTime) {
                return BigInteger.valueOf(Converter.localDateTimeToMillis((LocalDateTime)fromInstance));
            }
            if (fromInstance instanceof ZonedDateTime) {
                return BigInteger.valueOf(Converter.zonedDateTimeToMillis((ZonedDateTime)fromInstance));
            }
            if (fromInstance instanceof Calendar) {
                return new BigInteger(Long.toString(((Calendar)fromInstance).getTime().getTime()));
            }
            if (fromInstance instanceof Character) {
                return new BigInteger(Long.toString(((Character)fromInstance).charValue()));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'BigInteger'", e);
        }
        Converter.nope(fromInstance, "BigInteger");
        return null;
    }

    public static Date convertToSqlDate(Object fromInstance) {
        try {
            if (fromInstance instanceof Date) {
                return new Date(((Date)fromInstance).getTime());
            }
            if (fromInstance instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)fromInstance;
                return new Date(timestamp.getTime());
            }
            if (fromInstance instanceof java.util.Date) {
                return new Date(((java.util.Date)fromInstance).getTime());
            }
            if (fromInstance instanceof String) {
                java.util.Date date = DateUtilities.parseDate(((String)fromInstance).trim());
                if (date == null) {
                    return null;
                }
                return new Date(date.getTime());
            }
            if (fromInstance instanceof LocalDate) {
                return new Date(Converter.localDateToMillis((LocalDate)fromInstance));
            }
            if (fromInstance instanceof LocalDateTime) {
                return new Date(Converter.localDateTimeToMillis((LocalDateTime)fromInstance));
            }
            if (fromInstance instanceof ZonedDateTime) {
                return new Date(Converter.zonedDateTimeToMillis((ZonedDateTime)fromInstance));
            }
            if (fromInstance instanceof Calendar) {
                return new Date(((Calendar)fromInstance).getTime().getTime());
            }
            if (fromInstance instanceof Long) {
                return new Date((Long)fromInstance);
            }
            if (fromInstance instanceof BigInteger) {
                return new Date(((BigInteger)fromInstance).longValue());
            }
            if (fromInstance instanceof BigDecimal) {
                return new Date(((BigDecimal)fromInstance).longValue());
            }
            if (fromInstance instanceof AtomicLong) {
                return new Date(((AtomicLong)fromInstance).get());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'java.sql.Date'", e);
        }
        Converter.nope(fromInstance, "java.sql.Date");
        return null;
    }

    public static Timestamp convertToTimestamp(Object fromInstance) {
        try {
            if (fromInstance instanceof Date) {
                return new Timestamp(((Date)fromInstance).getTime());
            }
            if (fromInstance instanceof Timestamp) {
                return new Timestamp(((Timestamp)fromInstance).getTime());
            }
            if (fromInstance instanceof java.util.Date) {
                return new Timestamp(((java.util.Date)fromInstance).getTime());
            }
            if (fromInstance instanceof LocalDate) {
                return new Timestamp(Converter.localDateToMillis((LocalDate)fromInstance));
            }
            if (fromInstance instanceof LocalDateTime) {
                return new Timestamp(Converter.localDateTimeToMillis((LocalDateTime)fromInstance));
            }
            if (fromInstance instanceof ZonedDateTime) {
                return new Timestamp(Converter.zonedDateTimeToMillis((ZonedDateTime)fromInstance));
            }
            if (fromInstance instanceof String) {
                java.util.Date date = DateUtilities.parseDate(((String)fromInstance).trim());
                if (date == null) {
                    return null;
                }
                return new Timestamp(date.getTime());
            }
            if (fromInstance instanceof Calendar) {
                return new Timestamp(((Calendar)fromInstance).getTime().getTime());
            }
            if (fromInstance instanceof Long) {
                return new Timestamp((Long)fromInstance);
            }
            if (fromInstance instanceof BigInteger) {
                return new Timestamp(((BigInteger)fromInstance).longValue());
            }
            if (fromInstance instanceof BigDecimal) {
                return new Timestamp(((BigDecimal)fromInstance).longValue());
            }
            if (fromInstance instanceof AtomicLong) {
                return new Timestamp(((AtomicLong)fromInstance).get());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Timestamp'", e);
        }
        Converter.nope(fromInstance, "Timestamp");
        return null;
    }

    public static java.util.Date convertToDate(Object fromInstance) {
        try {
            if (fromInstance instanceof String) {
                return DateUtilities.parseDate(((String)fromInstance).trim());
            }
            if (fromInstance instanceof Date) {
                return new java.util.Date(((Date)fromInstance).getTime());
            }
            if (fromInstance instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)fromInstance;
                return new java.util.Date(timestamp.getTime());
            }
            if (fromInstance instanceof java.util.Date) {
                return new java.util.Date(((java.util.Date)fromInstance).getTime());
            }
            if (fromInstance instanceof LocalDate) {
                return new java.util.Date(Converter.localDateToMillis((LocalDate)fromInstance));
            }
            if (fromInstance instanceof LocalDateTime) {
                return new java.util.Date(Converter.localDateTimeToMillis((LocalDateTime)fromInstance));
            }
            if (fromInstance instanceof ZonedDateTime) {
                return new java.util.Date(Converter.zonedDateTimeToMillis((ZonedDateTime)fromInstance));
            }
            if (fromInstance instanceof Calendar) {
                return ((Calendar)fromInstance).getTime();
            }
            if (fromInstance instanceof Long) {
                return new java.util.Date((Long)fromInstance);
            }
            if (fromInstance instanceof BigInteger) {
                return new java.util.Date(((BigInteger)fromInstance).longValue());
            }
            if (fromInstance instanceof BigDecimal) {
                return new java.util.Date(((BigDecimal)fromInstance).longValue());
            }
            if (fromInstance instanceof AtomicLong) {
                return new java.util.Date(((AtomicLong)fromInstance).get());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Date'", e);
        }
        Converter.nope(fromInstance, "Date");
        return null;
    }

    public static LocalDate convertToLocalDate(Object fromInstance) {
        try {
            if (fromInstance instanceof String) {
                java.util.Date date = DateUtilities.parseDate(((String)fromInstance).trim());
                return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            }
            if (fromInstance instanceof LocalDate) {
                return (LocalDate)fromInstance;
            }
            if (fromInstance instanceof LocalDateTime) {
                return ((LocalDateTime)fromInstance).toLocalDate();
            }
            if (fromInstance instanceof ZonedDateTime) {
                return ((ZonedDateTime)fromInstance).toLocalDate();
            }
            if (fromInstance instanceof Date) {
                return ((Date)fromInstance).toLocalDate();
            }
            if (fromInstance instanceof Timestamp) {
                return ((Timestamp)fromInstance).toLocalDateTime().toLocalDate();
            }
            if (fromInstance instanceof java.util.Date) {
                return ((java.util.Date)fromInstance).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            }
            if (fromInstance instanceof Calendar) {
                return ((Calendar)fromInstance).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            }
            if (fromInstance instanceof Long) {
                Long dateInMillis = (Long)fromInstance;
                return Instant.ofEpochMilli(dateInMillis).atZone(ZoneId.systemDefault()).toLocalDate();
            }
            if (fromInstance instanceof BigInteger) {
                BigInteger big = (BigInteger)fromInstance;
                return Instant.ofEpochMilli(big.longValue()).atZone(ZoneId.systemDefault()).toLocalDate();
            }
            if (fromInstance instanceof BigDecimal) {
                BigDecimal big = (BigDecimal)fromInstance;
                return Instant.ofEpochMilli(big.longValue()).atZone(ZoneId.systemDefault()).toLocalDate();
            }
            if (fromInstance instanceof AtomicLong) {
                AtomicLong atomicLong = (AtomicLong)fromInstance;
                return Instant.ofEpochMilli(atomicLong.longValue()).atZone(ZoneId.systemDefault()).toLocalDate();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'LocalDate'", e);
        }
        Converter.nope(fromInstance, "LocalDate");
        return null;
    }

    public static LocalDateTime convertToLocalDateTime(Object fromInstance) {
        try {
            if (fromInstance instanceof String) {
                java.util.Date date = DateUtilities.parseDate(((String)fromInstance).trim());
                return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            if (fromInstance instanceof LocalDate) {
                return ((LocalDate)fromInstance).atStartOfDay();
            }
            if (fromInstance instanceof LocalDateTime) {
                return (LocalDateTime)fromInstance;
            }
            if (fromInstance instanceof ZonedDateTime) {
                return ((ZonedDateTime)fromInstance).toLocalDateTime();
            }
            if (fromInstance instanceof Date) {
                return ((Date)fromInstance).toLocalDate().atStartOfDay();
            }
            if (fromInstance instanceof Timestamp) {
                return ((Timestamp)fromInstance).toLocalDateTime();
            }
            if (fromInstance instanceof java.util.Date) {
                return ((java.util.Date)fromInstance).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            if (fromInstance instanceof Calendar) {
                return ((Calendar)fromInstance).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            if (fromInstance instanceof Long) {
                Long dateInMillis = (Long)fromInstance;
                return Instant.ofEpochMilli(dateInMillis).atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            if (fromInstance instanceof BigInteger) {
                BigInteger big = (BigInteger)fromInstance;
                return Instant.ofEpochMilli(big.longValue()).atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            if (fromInstance instanceof BigDecimal) {
                BigDecimal big = (BigDecimal)fromInstance;
                return Instant.ofEpochMilli(big.longValue()).atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            if (fromInstance instanceof AtomicLong) {
                AtomicLong atomicLong = (AtomicLong)fromInstance;
                return Instant.ofEpochMilli(atomicLong.longValue()).atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'LocalDateTime'", e);
        }
        Converter.nope(fromInstance, "LocalDateTime");
        return null;
    }

    public static ZonedDateTime convertToZonedDateTime(Object fromInstance) {
        try {
            if (fromInstance instanceof String) {
                java.util.Date date = DateUtilities.parseDate(((String)fromInstance).trim());
                return date.toInstant().atZone(ZoneId.systemDefault());
            }
            if (fromInstance instanceof LocalDate) {
                return ((LocalDate)fromInstance).atStartOfDay(ZoneId.systemDefault());
            }
            if (fromInstance instanceof LocalDateTime) {
                return ((LocalDateTime)fromInstance).atZone(ZoneId.systemDefault());
            }
            if (fromInstance instanceof ZonedDateTime) {
                return (ZonedDateTime)fromInstance;
            }
            if (fromInstance instanceof Date) {
                return ((Date)fromInstance).toLocalDate().atStartOfDay(ZoneId.systemDefault());
            }
            if (fromInstance instanceof Timestamp) {
                return ((Timestamp)fromInstance).toInstant().atZone(ZoneId.systemDefault());
            }
            if (fromInstance instanceof java.util.Date) {
                return ((java.util.Date)fromInstance).toInstant().atZone(ZoneId.systemDefault());
            }
            if (fromInstance instanceof Calendar) {
                return ((Calendar)fromInstance).toInstant().atZone(ZoneId.systemDefault());
            }
            if (fromInstance instanceof Long) {
                Long dateInMillis = (Long)fromInstance;
                return Instant.ofEpochMilli(dateInMillis).atZone(ZoneId.systemDefault());
            }
            if (fromInstance instanceof BigInteger) {
                BigInteger big = (BigInteger)fromInstance;
                return Instant.ofEpochMilli(big.longValue()).atZone(ZoneId.systemDefault());
            }
            if (fromInstance instanceof BigDecimal) {
                BigDecimal big = (BigDecimal)fromInstance;
                return Instant.ofEpochMilli(big.longValue()).atZone(ZoneId.systemDefault());
            }
            if (fromInstance instanceof AtomicLong) {
                AtomicLong atomicLong = (AtomicLong)fromInstance;
                return Instant.ofEpochMilli(atomicLong.longValue()).atZone(ZoneId.systemDefault());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'LocalDateTime'", e);
        }
        Converter.nope(fromInstance, "LocalDateTime");
        return null;
    }

    public static Calendar convertToCalendar(Object fromInstance) {
        if (fromInstance == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(Converter.convertToDate(fromInstance));
        return calendar;
    }

    public static char convert2char(Object fromInstance) {
        if (fromInstance == null) {
            return '\u0000';
        }
        return Converter.convertToCharacter(fromInstance).charValue();
    }

    public static Character convertToCharacter(Object fromInstance) {
        try {
            if (fromInstance instanceof String) {
                if ("".equals(fromInstance)) {
                    return Character.valueOf('\u0000');
                }
                return Character.valueOf((char)Integer.parseInt(((String)fromInstance).trim()));
            }
            if (fromInstance instanceof Number) {
                return Character.valueOf((char)((Number)fromInstance).shortValue());
            }
            if (fromInstance instanceof Boolean) {
                return Character.valueOf((Boolean)fromInstance != false ? (char)'1' : '0');
            }
            if (fromInstance instanceof AtomicBoolean) {
                return Character.valueOf(((AtomicBoolean)fromInstance).get() ? (char)'1' : '0');
            }
            if (fromInstance instanceof Character) {
                return (Character)fromInstance;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Character'", e);
        }
        Converter.nope(fromInstance, "Character");
        return null;
    }

    public static byte convert2byte(Object fromInstance) {
        if (fromInstance == null) {
            return 0;
        }
        return Converter.convertToByte(fromInstance);
    }

    public static Byte convertToByte(Object fromInstance) {
        try {
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return BYTE_ZERO;
                }
                try {
                    return Byte.valueOf(((String)fromInstance).trim());
                }
                catch (NumberFormatException e) {
                    long value = Converter.convertToBigDecimal(fromInstance).longValue();
                    if (value < -128L || value > 127L) {
                        throw new NumberFormatException("Value: " + fromInstance + " outside -128 to 127");
                    }
                    return (byte)value;
                }
            }
            if (fromInstance instanceof Byte) {
                return (Byte)fromInstance;
            }
            if (fromInstance instanceof Number) {
                return ((Number)fromInstance).byteValue();
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? BYTE_ONE : BYTE_ZERO;
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? BYTE_ONE : BYTE_ZERO;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Byte'", e);
        }
        Converter.nope(fromInstance, "Byte");
        return null;
    }

    public static short convert2short(Object fromInstance) {
        if (fromInstance == null) {
            return 0;
        }
        return Converter.convertToShort(fromInstance);
    }

    public static Short convertToShort(Object fromInstance) {
        try {
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return SHORT_ZERO;
                }
                try {
                    return Short.valueOf(((String)fromInstance).trim());
                }
                catch (NumberFormatException e) {
                    long value = Converter.convertToBigDecimal(fromInstance).longValue();
                    if (value < -32768L || value > 32767L) {
                        throw new NumberFormatException("Value: " + fromInstance + " outside -32768 to 32767");
                    }
                    return (short)value;
                }
            }
            if (fromInstance instanceof Short) {
                return (Short)fromInstance;
            }
            if (fromInstance instanceof Number) {
                return ((Number)fromInstance).shortValue();
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? SHORT_ONE : SHORT_ZERO;
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? SHORT_ONE : SHORT_ZERO;
            }
            if (fromInstance instanceof Character) {
                return (short)((Character)fromInstance).charValue();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Short'", e);
        }
        Converter.nope(fromInstance, "Short");
        return null;
    }

    public static int convert2int(Object fromInstance) {
        if (fromInstance == null) {
            return 0;
        }
        return Converter.convertToInteger(fromInstance);
    }

    public static Integer convertToInteger(Object fromInstance) {
        try {
            if (fromInstance instanceof Integer) {
                return (Integer)fromInstance;
            }
            if (fromInstance instanceof Number) {
                return ((Number)fromInstance).intValue();
            }
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return INTEGER_ZERO;
                }
                try {
                    return Integer.valueOf(((String)fromInstance).trim());
                }
                catch (NumberFormatException e) {
                    long value = Converter.convertToBigDecimal(fromInstance).longValue();
                    if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                        throw new NumberFormatException("Value: " + fromInstance + " outside -2147483648 to 2147483647");
                    }
                    return (int)value;
                }
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? INTEGER_ONE : INTEGER_ZERO;
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? INTEGER_ONE : INTEGER_ZERO;
            }
            if (fromInstance instanceof Character) {
                return ((Character)fromInstance).charValue();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to an 'Integer'", e);
        }
        Converter.nope(fromInstance, "Integer");
        return null;
    }

    public static long convert2long(Object fromInstance) {
        if (fromInstance == null) {
            return LONG_ZERO;
        }
        return Converter.convertToLong(fromInstance);
    }

    public static Long convertToLong(Object fromInstance) {
        try {
            if (fromInstance instanceof Long) {
                return (Long)fromInstance;
            }
            if (fromInstance instanceof String) {
                if ("".equals(fromInstance)) {
                    return LONG_ZERO;
                }
                try {
                    return Long.valueOf(((String)fromInstance).trim());
                }
                catch (NumberFormatException e) {
                    return Converter.convertToBigDecimal(fromInstance).longValue();
                }
            }
            if (fromInstance instanceof Number) {
                return ((Number)fromInstance).longValue();
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? LONG_ONE : LONG_ZERO;
            }
            if (fromInstance instanceof java.util.Date) {
                return ((java.util.Date)fromInstance).getTime();
            }
            if (fromInstance instanceof LocalDate) {
                return Converter.localDateToMillis((LocalDate)fromInstance);
            }
            if (fromInstance instanceof LocalDateTime) {
                return Converter.localDateTimeToMillis((LocalDateTime)fromInstance);
            }
            if (fromInstance instanceof ZonedDateTime) {
                return Converter.zonedDateTimeToMillis((ZonedDateTime)fromInstance);
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? LONG_ONE : LONG_ZERO;
            }
            if (fromInstance instanceof Calendar) {
                return ((Calendar)fromInstance).getTime().getTime();
            }
            if (fromInstance instanceof Character) {
                return ((Character)fromInstance).charValue();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Long'", e);
        }
        Converter.nope(fromInstance, "Long");
        return null;
    }

    public static float convert2float(Object fromInstance) {
        if (fromInstance == null) {
            return FLOAT_ZERO.floatValue();
        }
        return Converter.convertToFloat(fromInstance).floatValue();
    }

    public static Float convertToFloat(Object fromInstance) {
        try {
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return FLOAT_ZERO;
                }
                return Float.valueOf(((String)fromInstance).trim());
            }
            if (fromInstance instanceof Float) {
                return (Float)fromInstance;
            }
            if (fromInstance instanceof Number) {
                return Float.valueOf(((Number)fromInstance).floatValue());
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? FLOAT_ONE : FLOAT_ZERO;
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? FLOAT_ONE : FLOAT_ZERO;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Float'", e);
        }
        Converter.nope(fromInstance, "Float");
        return null;
    }

    public static double convert2double(Object fromInstance) {
        if (fromInstance == null) {
            return DOUBLE_ZERO;
        }
        return Converter.convertToDouble(fromInstance);
    }

    public static Double convertToDouble(Object fromInstance) {
        try {
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return DOUBLE_ZERO;
                }
                return Double.valueOf(((String)fromInstance).trim());
            }
            if (fromInstance instanceof Double) {
                return (Double)fromInstance;
            }
            if (fromInstance instanceof Number) {
                return ((Number)fromInstance).doubleValue();
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? DOUBLE_ONE : DOUBLE_ZERO;
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? DOUBLE_ONE : DOUBLE_ZERO;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Double'", e);
        }
        Converter.nope(fromInstance, "Double");
        return null;
    }

    public static boolean convert2boolean(Object fromInstance) {
        if (fromInstance == null) {
            return false;
        }
        return Converter.convertToBoolean(fromInstance);
    }

    public static Boolean convertToBoolean(Object fromInstance) {
        if (fromInstance instanceof Boolean) {
            return (Boolean)fromInstance;
        }
        if (fromInstance instanceof String) {
            if ("true".equals(fromInstance)) {
                return true;
            }
            if ("false".equals(fromInstance)) {
                return false;
            }
            return "true".equalsIgnoreCase((String)fromInstance);
        }
        if (fromInstance instanceof Number) {
            return ((Number)fromInstance).longValue() != 0L;
        }
        if (fromInstance instanceof AtomicBoolean) {
            return ((AtomicBoolean)fromInstance).get();
        }
        Converter.nope(fromInstance, "Boolean");
        return null;
    }

    public static AtomicInteger convert2AtomicInteger(Object fromInstance) {
        if (fromInstance == null) {
            return new AtomicInteger(0);
        }
        return Converter.convertToAtomicInteger(fromInstance);
    }

    public static AtomicInteger convertToAtomicInteger(Object fromInstance) {
        try {
            if (fromInstance instanceof AtomicInteger) {
                return new AtomicInteger(((AtomicInteger)fromInstance).get());
            }
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return new AtomicInteger(0);
                }
                return new AtomicInteger(Integer.parseInt(((String)fromInstance).trim()));
            }
            if (fromInstance instanceof Number) {
                return new AtomicInteger(((Number)fromInstance).intValue());
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? new AtomicInteger(1) : new AtomicInteger(0);
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? new AtomicInteger(1) : new AtomicInteger(0);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to an 'AtomicInteger'", e);
        }
        Converter.nope(fromInstance, "AtomicInteger");
        return null;
    }

    public static AtomicLong convert2AtomicLong(Object fromInstance) {
        if (fromInstance == null) {
            return new AtomicLong(0L);
        }
        return Converter.convertToAtomicLong(fromInstance);
    }

    public static AtomicLong convertToAtomicLong(Object fromInstance) {
        try {
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return new AtomicLong(0L);
                }
                return new AtomicLong(Long.parseLong(((String)fromInstance).trim()));
            }
            if (fromInstance instanceof AtomicLong) {
                return new AtomicLong(((AtomicLong)fromInstance).get());
            }
            if (fromInstance instanceof Number) {
                return new AtomicLong(((Number)fromInstance).longValue());
            }
            if (fromInstance instanceof java.util.Date) {
                return new AtomicLong(((java.util.Date)fromInstance).getTime());
            }
            if (fromInstance instanceof LocalDate) {
                return new AtomicLong(Converter.localDateToMillis((LocalDate)fromInstance));
            }
            if (fromInstance instanceof LocalDateTime) {
                return new AtomicLong(Converter.localDateTimeToMillis((LocalDateTime)fromInstance));
            }
            if (fromInstance instanceof ZonedDateTime) {
                return new AtomicLong(Converter.zonedDateTimeToMillis((ZonedDateTime)fromInstance));
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? new AtomicLong(1L) : new AtomicLong(0L);
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? new AtomicLong(1L) : new AtomicLong(0L);
            }
            if (fromInstance instanceof Calendar) {
                return new AtomicLong(((Calendar)fromInstance).getTime().getTime());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to an 'AtomicLong'", e);
        }
        Converter.nope(fromInstance, "AtomicLong");
        return null;
    }

    public static AtomicBoolean convert2AtomicBoolean(Object fromInstance) {
        if (fromInstance == null) {
            return new AtomicBoolean(false);
        }
        return Converter.convertToAtomicBoolean(fromInstance);
    }

    public static AtomicBoolean convertToAtomicBoolean(Object fromInstance) {
        if (fromInstance instanceof String) {
            if (StringUtilities.isEmpty((String)fromInstance)) {
                return new AtomicBoolean(false);
            }
            String value = (String)fromInstance;
            return new AtomicBoolean("true".equalsIgnoreCase(value));
        }
        if (fromInstance instanceof AtomicBoolean) {
            return new AtomicBoolean(((AtomicBoolean)fromInstance).get());
        }
        if (fromInstance instanceof Boolean) {
            return new AtomicBoolean((Boolean)fromInstance);
        }
        if (fromInstance instanceof Number) {
            return new AtomicBoolean(((Number)fromInstance).longValue() != 0L);
        }
        Converter.nope(fromInstance, "AtomicBoolean");
        return null;
    }

    private static String nope(Object fromInstance, String targetType) {
        if (fromInstance == null) {
            return null;
        }
        throw new IllegalArgumentException("Unsupported value type [" + Converter.name(fromInstance) + "] attempting to convert to '" + targetType + "'");
    }

    private static String name(Object fromInstance) {
        return fromInstance.getClass().getName() + " (" + fromInstance.toString() + ")";
    }

    public static long localDateToMillis(LocalDate localDate) {
        return localDate.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long localDateTimeToMillis(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long zonedDateTimeToMillis(ZonedDateTime zonedDateTime) {
        return zonedDateTime.toInstant().toEpochMilli();
    }

    static {
        conversion.put(String.class, Converter::convertToString);
        conversion.put(Long.TYPE, Converter::convert2long);
        conversion.put(Long.class, Converter::convertToLong);
        conversion.put(Integer.TYPE, Converter::convert2int);
        conversion.put(Integer.class, Converter::convertToInteger);
        conversion.put(Short.TYPE, Converter::convert2short);
        conversion.put(Short.class, Converter::convertToShort);
        conversion.put(Byte.TYPE, Converter::convert2byte);
        conversion.put(Byte.class, Converter::convertToByte);
        conversion.put(Character.TYPE, Converter::convert2char);
        conversion.put(Boolean.TYPE, Converter::convert2boolean);
        conversion.put(Boolean.class, Converter::convertToBoolean);
        conversion.put(Double.TYPE, Converter::convert2double);
        conversion.put(Double.class, Converter::convertToDouble);
        conversion.put(Float.TYPE, Converter::convert2float);
        conversion.put(Float.class, Converter::convertToFloat);
        conversion.put(Character.class, Converter::convertToCharacter);
        conversion.put(Calendar.class, Converter::convertToCalendar);
        conversion.put(java.util.Date.class, Converter::convertToDate);
        conversion.put(LocalDate.class, Converter::convertToLocalDate);
        conversion.put(LocalDateTime.class, Converter::convertToLocalDateTime);
        conversion.put(ZonedDateTime.class, Converter::convertToZonedDateTime);
        conversion.put(BigDecimal.class, Converter::convertToBigDecimal);
        conversion.put(BigInteger.class, Converter::convertToBigInteger);
        conversion.put(Date.class, Converter::convertToSqlDate);
        conversion.put(Timestamp.class, Converter::convertToTimestamp);
        conversion.put(AtomicInteger.class, Converter::convertToAtomicInteger);
        conversion.put(AtomicLong.class, Converter::convertToAtomicLong);
        conversion.put(AtomicBoolean.class, Converter::convertToAtomicBoolean);
        conversionToString.put(String.class, fromInstance -> fromInstance);
        conversionToString.put(BigDecimal.class, fromInstance -> {
            BigDecimal bd = Converter.convertToBigDecimal(fromInstance);
            return bd.stripTrailingZeros().toPlainString();
        });
        conversionToString.put(BigInteger.class, fromInstance -> {
            BigInteger bi = Converter.convertToBigInteger(fromInstance);
            return bi.toString();
        });
        Work<Object> toString2 = Object::toString;
        conversionToString.put(Boolean.class, toString2);
        conversionToString.put(AtomicBoolean.class, toString2);
        conversionToString.put(Byte.class, toString2);
        conversionToString.put(Short.class, toString2);
        conversionToString.put(Integer.class, toString2);
        conversionToString.put(AtomicInteger.class, toString2);
        conversionToString.put(Long.class, toString2);
        conversionToString.put(AtomicLong.class, toString2);
        Work<Object> toNoExpString = Object::toString;
        conversionToString.put(Double.class, toNoExpString);
        conversionToString.put(Float.class, toNoExpString);
        conversionToString.put(java.util.Date.class, fromInstance -> SafeSimpleDateFormat.getDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(fromInstance));
        conversionToString.put(Character.class, fromInstance -> "" + fromInstance);
        conversionToString.put(LocalDate.class, fromInstance -> {
            LocalDate localDate = (LocalDate)fromInstance;
            return String.format("%04d-%02d-%02d", localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
        });
        conversionToString.put(LocalDateTime.class, fromInstance -> {
            LocalDateTime localDateTime = (LocalDateTime)fromInstance;
            return String.format("%04d-%02d-%02dT%02d:%02d:%02d", localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond());
        });
        conversionToString.put(ZonedDateTime.class, fromInstance -> {
            ZonedDateTime zonedDateTime = (ZonedDateTime)fromInstance;
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");
            return zonedDateTime.format(formatter);
        });
    }

    protected static interface Work<T> {
        public Object convert(T var1);
    }
}

