/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.grpc;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.MeterProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.ExporterMetrics;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.grpc.GrpcExporterUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.grpc.GrpcSender;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.ThrottlingLogger;

public final class GrpcExporter<T extends Marshaler> {
    private static final Logger internalLogger = Logger.getLogger(GrpcExporter.class.getName());
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final AtomicBoolean loggedUnimplemented = new AtomicBoolean();
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final String type;
    private final GrpcSender<T> grpcSender;
    private final ExporterMetrics exporterMetrics;

    public GrpcExporter(String exporterName, String type, GrpcSender<T> grpcSender, Supplier<MeterProvider> meterProviderSupplier) {
        this.type = type;
        this.grpcSender = grpcSender;
        this.exporterMetrics = ExporterMetrics.createGrpc(exporterName, type, meterProviderSupplier);
    }

    public CompletableResultCode export(T exportRequest, int numItems) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        this.exporterMetrics.addSeen(numItems);
        CompletableResultCode result = new CompletableResultCode();
        this.grpcSender.send(exportRequest, () -> {
            this.exporterMetrics.addSuccess(numItems);
            result.succeed();
        }, (response, throwable) -> {
            this.exporterMetrics.addFailed(numItems);
            switch (response.grpcStatusValue()) {
                case 12: {
                    if (!this.loggedUnimplemented.compareAndSet(false, true)) break;
                    GrpcExporterUtil.logUnimplemented(internalLogger, this.type, response.grpcStatusDescription());
                    break;
                }
                case 14: {
                    this.logger.log(Level.SEVERE, "Failed to export " + this.type + "s. Server is UNAVAILABLE. Make sure your collector is running and reachable from this network. Full error message:" + response.grpcStatusDescription());
                    break;
                }
                default: {
                    this.logger.log(Level.WARNING, "Failed to export " + this.type + "s. Server responded with gRPC status code " + response.grpcStatusValue() + ". Error message: " + response.grpcStatusDescription());
                }
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, "Failed to export " + this.type + "s. Details follow: " + throwable);
            }
            result.fail();
        });
        return result;
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            this.logger.log(Level.INFO, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.grpcSender.shutdown();
    }
}

