/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.Collection;
import javax.annotation.concurrent.Immutable;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.MetricData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.PointData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator.DropAggregator;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.state.Measurement;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.resources.Resource;

@Immutable
public interface Aggregator<T extends PointData, U extends ExemplarData> {
    public static Aggregator<?, DoubleExemplarData> drop() {
        return DropAggregator.INSTANCE;
    }

    public AggregatorHandle<T, U> createHandle();

    default public T diff(T previousCumulative, T currentCumulative) {
        throw new UnsupportedOperationException("This aggregator does not support diff.");
    }

    default public void diffInPlace(T previousCumulativeReusable, T currentCumulative) {
        throw new UnsupportedOperationException("This aggregator does not support diffInPlace.");
    }

    default public T toPoint(Measurement measurement) {
        throw new UnsupportedOperationException("This aggregator does not support toPoint.");
    }

    default public void toPoint(Measurement measurement, T reusablePoint) {
        throw new UnsupportedOperationException("This aggregator does not support toPoint.");
    }

    default public T createReusablePoint() {
        throw new UnsupportedOperationException("This aggregator does not support createReusablePoint.");
    }

    default public void copyPoint(T point, T toReusablePoint) {
        throw new UnsupportedOperationException("This aggregator does not support toPoint.");
    }

    public MetricData toMetricData(Resource var1, InstrumentationScopeInfo var2, MetricDescriptor var3, Collection<T> var4, AggregationTemporality var5);
}

