/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.model;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;
import org.apache.shardingsphere.infra.metadata.identifier.ShardingSphereIdentifier;

public final class ShardingSphereSchema {
    private final String name;
    private final Map<ShardingSphereIdentifier, ShardingSphereTable> tables;
    private final Map<ShardingSphereIdentifier, ShardingSphereView> views;

    public ShardingSphereSchema(String name) {
        this.name = name;
        this.tables = new ConcurrentHashMap<ShardingSphereIdentifier, ShardingSphereTable>();
        this.views = new ConcurrentHashMap<ShardingSphereIdentifier, ShardingSphereView>();
    }

    public ShardingSphereSchema(String name, Collection<ShardingSphereTable> tables, Collection<ShardingSphereView> views) {
        this.name = name;
        this.tables = new ConcurrentHashMap<ShardingSphereIdentifier, ShardingSphereTable>(tables.size(), 1.0f);
        this.views = new ConcurrentHashMap<ShardingSphereIdentifier, ShardingSphereView>(views.size(), 1.0f);
        tables.forEach(each -> this.tables.put(new ShardingSphereIdentifier(each.getName()), (ShardingSphereTable)each));
        views.forEach(each -> this.views.put(new ShardingSphereIdentifier(each.getName()), (ShardingSphereView)each));
    }

    public Collection<ShardingSphereTable> getAllTables() {
        return this.tables.values();
    }

    public boolean containsTable(String tableName) {
        return this.tables.containsKey(new ShardingSphereIdentifier(tableName));
    }

    public ShardingSphereTable getTable(String tableName) {
        return this.tables.get(new ShardingSphereIdentifier(tableName));
    }

    public void putTable(ShardingSphereTable table) {
        this.tables.put(new ShardingSphereIdentifier(table.getName()), table);
    }

    public void removeTable(String tableName) {
        this.tables.remove(new ShardingSphereIdentifier(tableName));
    }

    public Collection<ShardingSphereView> getAllViews() {
        return this.views.values();
    }

    public boolean containsView(String viewName) {
        return this.views.containsKey(new ShardingSphereIdentifier(viewName));
    }

    public ShardingSphereView getView(String viewName) {
        return this.views.get(new ShardingSphereIdentifier(viewName));
    }

    public void putView(ShardingSphereView view) {
        this.views.put(new ShardingSphereIdentifier(view.getName()), view);
    }

    public void removeView(String viewName) {
        this.views.remove(new ShardingSphereIdentifier(viewName));
    }

    public boolean containsIndex(String tableName, String indexName) {
        return this.containsTable(tableName) && this.getTable(tableName).containsIndex(indexName);
    }

    public List<String> getVisibleColumnNames(String tableName) {
        return this.containsTable(tableName) ? this.getTable(tableName).getVisibleColumns() : Collections.emptyList();
    }

    public Map<String, Integer> getVisibleColumnAndIndexMap(String tableName) {
        return this.containsTable(tableName) ? this.getTable(tableName).getVisibleColumnAndIndexMap() : Collections.emptyMap();
    }

    public boolean isEmpty() {
        return this.tables.isEmpty() && this.views.isEmpty();
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

