/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.statistics.builder.dialect;

import java.util.Collections;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereDatabaseData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereRowData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereSchemaData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.statistics.builder.ShardingSphereStatisticsBuilder;

public final class MySQLShardingSphereStatisticsBuilder
implements ShardingSphereStatisticsBuilder {
    private static final String SHARDINGSPHERE = "shardingsphere";
    private static final String CLUSTER_INFORMATION = "cluster_information";
    private static final String SHARDING_TABLE_STATISTICS = "sharding_table_statistics";

    @Override
    public ShardingSphereDatabaseData build(ShardingSphereDatabase database) {
        ShardingSphereDatabaseData result = new ShardingSphereDatabaseData();
        if (database.containsSchema(SHARDINGSPHERE)) {
            ShardingSphereSchemaData schemaData = new ShardingSphereSchemaData();
            this.initClusterInformationTable(schemaData);
            this.initShardingTableStatisticsTable(schemaData);
            result.putSchema(SHARDINGSPHERE, schemaData);
        }
        return result;
    }

    private void initClusterInformationTable(ShardingSphereSchemaData schemaData) {
        ShardingSphereTableData tableData = new ShardingSphereTableData(CLUSTER_INFORMATION);
        tableData.getRows().add(new ShardingSphereRowData(Collections.singletonList("5.5.2")));
        schemaData.putTable(CLUSTER_INFORMATION, tableData);
    }

    private void initShardingTableStatisticsTable(ShardingSphereSchemaData schemaData) {
        schemaData.putTable(SHARDING_TABLE_STATISTICS, new ShardingSphereTableData(SHARDING_TABLE_STATISTICS));
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

