/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.merge;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.engine.ResultProcessEngine;
import org.apache.shardingsphere.infra.merge.engine.decorator.ResultDecorator;
import org.apache.shardingsphere.infra.merge.engine.decorator.ResultDecoratorEngine;
import org.apache.shardingsphere.infra.merge.engine.decorator.impl.TransparentResultDecorator;
import org.apache.shardingsphere.infra.merge.engine.merger.ResultMerger;
import org.apache.shardingsphere.infra.merge.engine.merger.ResultMergerEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;

public final class MergeEngine {
    private final ShardingSphereMetaData metaData;
    private final ShardingSphereDatabase database;
    private final ConfigurationProperties props;
    private final Map<ShardingSphereRule, ResultProcessEngine> engines;
    private final ConnectionContext connectionContext;

    public MergeEngine(ShardingSphereMetaData metaData, ShardingSphereDatabase database, ConfigurationProperties props, ConnectionContext connectionContext) {
        this.metaData = metaData;
        this.database = database;
        this.props = props;
        this.engines = OrderedSPILoader.getServices(ResultProcessEngine.class, (Collection)database.getRuleMetaData().getRules());
        this.connectionContext = connectionContext;
    }

    public MergedResult merge(List<QueryResult> queryResults, SQLStatementContext sqlStatementContext) throws SQLException {
        MergedResult mergedResult = this.executeMerge(queryResults, sqlStatementContext).orElseGet(() -> new TransparentMergedResult((QueryResult)queryResults.get(0)));
        return this.decorate(mergedResult, sqlStatementContext);
    }

    private Optional<MergedResult> executeMerge(List<QueryResult> queryResults, SQLStatementContext sqlStatementContext) throws SQLException {
        for (Map.Entry<ShardingSphereRule, ResultProcessEngine> entry : this.engines.entrySet()) {
            if (!(entry.getValue() instanceof ResultMergerEngine)) continue;
            ResultMerger resultMerger = ((ResultMergerEngine)entry.getValue()).newInstance(this.database.getName(), this.database.getProtocolType(), entry.getKey(), this.props, sqlStatementContext);
            return Optional.of(resultMerger.merge(queryResults, sqlStatementContext, this.database, this.connectionContext));
        }
        return Optional.empty();
    }

    private MergedResult decorate(MergedResult mergedResult, SQLStatementContext sqlStatementContext) throws SQLException {
        MergedResult result = null;
        for (Map.Entry<ShardingSphereRule, ResultProcessEngine> entry : this.engines.entrySet()) {
            if (!(entry.getValue() instanceof ResultDecoratorEngine)) continue;
            ResultDecorator resultDecorator = this.getResultDecorator(sqlStatementContext, entry.getValue());
            result = null == result ? resultDecorator.decorate(mergedResult, sqlStatementContext, entry.getKey()) : resultDecorator.decorate(result, sqlStatementContext, entry.getKey());
        }
        return null == result ? mergedResult : result;
    }

    private ResultDecorator getResultDecorator(SQLStatementContext sqlStatementContext, ResultProcessEngine resultProcessEngine) {
        return (ResultDecorator)((ResultDecoratorEngine)resultProcessEngine).newInstance(this.metaData, this.database, this.props, sqlStatementContext).orElseGet(TransparentResultDecorator::new);
    }
}

