/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.shardingsphere.data.pipeline.core.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.core.constant.PipelineSQLOperationType;
import org.apache.shardingsphere.data.pipeline.core.exception.IngestException;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineInternalException;
import org.apache.shardingsphere.data.pipeline.core.exception.param.PipelineInvalidParameterException;
import org.apache.shardingsphere.data.pipeline.core.execute.AbstractPipelineLifecycleRunnable;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.Dumper;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.InventoryDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.column.InventoryColumnValueReaderEngine;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.position.InventoryDataRecordPositionCreator;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.InventoryQueryParameter;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.point.InventoryPointQueryParameter;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.range.InventoryRangeQueryParameter;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.range.QueryRange;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.finished.IngestFinishedPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.pk.PrimaryKeyIngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.pk.PrimaryKeyIngestPositionFactory;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.FinishedRecord;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.NormalColumn;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Record;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineTableMetaData;
import org.apache.shardingsphere.data.pipeline.core.query.JDBCStreamQueryBuilder;
import org.apache.shardingsphere.data.pipeline.core.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.sql.BuildDivisibleSQLParameter;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.sql.PipelineInventoryDumpSQLBuilder;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineJdbcUtils;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InventoryDumper
extends AbstractPipelineLifecycleRunnable
implements Dumper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InventoryDumper.class);
    private final InventoryDumperContext dumperContext;
    private final PipelineChannel channel;
    private final DataSource dataSource;
    private final PipelineTableMetaDataLoader metaDataLoader;
    private final InventoryDataRecordPositionCreator positionCreator;
    private final PipelineInventoryDumpSQLBuilder sqlBuilder;
    private final InventoryColumnValueReaderEngine columnValueReaderEngine;
    private final AtomicReference<Statement> runningStatement = new AtomicReference();

    public InventoryDumper(InventoryDumperContext dumperContext, PipelineChannel channel, DataSource dataSource, PipelineTableMetaDataLoader metaDataLoader, InventoryDataRecordPositionCreator positionCreator) {
        this.dumperContext = dumperContext;
        this.channel = channel;
        this.dataSource = dataSource;
        this.metaDataLoader = metaDataLoader;
        this.positionCreator = positionCreator;
        DatabaseType databaseType = dumperContext.getCommonContext().getDataSourceConfig().getDatabaseType();
        this.sqlBuilder = new PipelineInventoryDumpSQLBuilder(databaseType);
        this.columnValueReaderEngine = new InventoryColumnValueReaderEngine(databaseType);
    }

    @Override
    protected void runBlocking() {
        IngestPosition position = this.dumperContext.getCommonContext().getPosition();
        if (position instanceof IngestFinishedPosition) {
            log.info("Ignored because of already finished.");
            return;
        }
        PipelineTableMetaData tableMetaData = this.getPipelineTableMetaData();
        try (Connection connection = this.dataSource.getConnection();){
            if (StringUtils.isNotBlank((CharSequence)this.dumperContext.getQuerySQL()) || !this.dumperContext.hasUniqueKey() || this.isPrimaryKeyWithoutRange(position)) {
                this.dumpWithStreamingQuery(connection, tableMetaData);
            } else {
                this.dumpByPage(connection, tableMetaData);
            }
        }
        catch (RuntimeException | SQLException ex) {
            log.error("Inventory dump failed on {}", (Object)this.dumperContext.getActualTableName(), (Object)ex);
            throw new IngestException("Inventory dump failed on " + this.dumperContext.getActualTableName(), ex);
        }
    }

    private PipelineTableMetaData getPipelineTableMetaData() {
        String schemaName = this.dumperContext.getCommonContext().getTableAndSchemaNameMapper().getSchemaName(this.dumperContext.getLogicTableName());
        String tableName = this.dumperContext.getActualTableName();
        return this.metaDataLoader.getTableMetaData(schemaName, tableName);
    }

    private boolean isPrimaryKeyWithoutRange(IngestPosition position) {
        return position instanceof PrimaryKeyIngestPosition && null == ((PrimaryKeyIngestPosition)position).getBeginValue() && null == ((PrimaryKeyIngestPosition)position).getEndValue();
    }

    private void dumpByPage(Connection connection, PipelineTableMetaData tableMetaData) throws SQLException {
        log.info("Start to dump inventory data by page, dataSource={}, actualTable={}", (Object)this.dumperContext.getCommonContext().getDataSourceName(), (Object)this.dumperContext.getActualTableName());
        if (null != this.dumperContext.getTransactionIsolation()) {
            connection.setTransactionIsolation(this.dumperContext.getTransactionIsolation());
        }
        boolean firstQuery = true;
        AtomicLong rowCount = new AtomicLong();
        IngestPosition position = this.dumperContext.getCommonContext().getPosition();
        do {
            QueryRange queryRange;
            InventoryQueryParameter<QueryRange> queryParam;
            List<Record> dataRecords;
            if ((dataRecords = this.dumpByPage(connection, queryParam = new InventoryRangeQueryParameter(queryRange = new QueryRange(((PrimaryKeyIngestPosition)position).getBeginValue(), firstQuery && this.dumperContext.isFirstDump(), ((PrimaryKeyIngestPosition)position).getEndValue())), rowCount, tableMetaData)).size() > 1 && Objects.deepEquals(this.getFirstUniqueKeyValue(dataRecords, 0), this.getFirstUniqueKeyValue(dataRecords, dataRecords.size() - 1))) {
                queryParam = new InventoryPointQueryParameter(this.getFirstUniqueKeyValue(dataRecords, 0));
                dataRecords = this.dumpByPage(connection, queryParam, rowCount, tableMetaData);
            }
            firstQuery = false;
            if (dataRecords.isEmpty()) {
                position = new IngestFinishedPosition();
                dataRecords.add(new FinishedRecord(position));
                log.info("Inventory dump done, rowCount={}, dataSource={}, actualTable={}", new Object[]{rowCount, this.dumperContext.getCommonContext().getDataSourceName(), this.dumperContext.getActualTableName()});
            } else {
                position = PrimaryKeyIngestPositionFactory.newInstance(this.getFirstUniqueKeyValue(dataRecords, dataRecords.size() - 1), queryRange.getUpper());
            }
            this.channel.push(dataRecords);
            this.dumperContext.getCommonContext().setPosition(position);
        } while (!(position instanceof IngestFinishedPosition));
        log.info("End to dump inventory data by page, dataSource={}, actualTable={}", (Object)this.dumperContext.getCommonContext().getDataSourceName(), (Object)this.dumperContext.getActualTableName());
    }

    /*
     * Exception decompiling
     */
    private List<Record> dumpByPage(Connection connection, InventoryQueryParameter<?> queryParam, AtomicLong rowCount, PipelineTableMetaData tableMetaData) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setParameters(PreparedStatement preparedStatement, InventoryQueryParameter<?> queryParam) throws SQLException {
        if (queryParam instanceof InventoryRangeQueryParameter) {
            Object upper;
            Object lower = ((InventoryRangeQueryParameter)queryParam).getValue().getLower();
            if (null != lower) {
                preparedStatement.setObject(1, lower);
            }
            if (null != (upper = ((InventoryRangeQueryParameter)queryParam).getValue().getUpper())) {
                preparedStatement.setObject(2, upper);
            }
            preparedStatement.setInt(3, this.dumperContext.getBatchSize());
        } else if (queryParam instanceof InventoryPointQueryParameter) {
            preparedStatement.setObject(1, queryParam.getValue());
        } else {
            throw new UnsupportedOperationException("Query type: " + queryParam.getValue());
        }
    }

    private DataRecord loadDataRecord(ResultSet resultSet, ResultSetMetaData resultSetMetaData, PipelineTableMetaData tableMetaData) throws SQLException {
        int columnCount = resultSetMetaData.getColumnCount();
        String tableName = this.dumperContext.getLogicTableName();
        DataRecord result = new DataRecord(PipelineSQLOperationType.INSERT, tableName, this.positionCreator.create(this.dumperContext, resultSet), columnCount);
        List insertColumnNames = Optional.ofNullable(this.dumperContext.getInsertColumnNames()).orElse(Collections.emptyList());
        ShardingSpherePreconditions.checkState((insertColumnNames.isEmpty() || insertColumnNames.size() == resultSetMetaData.getColumnCount() ? 1 : 0) != 0, () -> new PipelineInvalidParameterException("Insert column names count not equals ResultSet column count"));
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = insertColumnNames.isEmpty() ? resultSetMetaData.getColumnName(i) : (String)insertColumnNames.get(i - 1);
            ShardingSpherePreconditions.checkNotNull((Object)tableMetaData.getColumnMetaData(columnName), () -> new PipelineInvalidParameterException(String.format("Column name is %s", columnName)));
            result.addColumn(new NormalColumn(columnName, this.columnValueReaderEngine.read(resultSet, resultSetMetaData, i), true, tableMetaData.getColumnMetaData(columnName).isUniqueKey()));
        }
        result.setActualTableName(this.dumperContext.getActualTableName());
        return result;
    }

    private String buildDumpByPageSQL(InventoryQueryParameter<?> queryParam) {
        String schemaName = this.dumperContext.getCommonContext().getTableAndSchemaNameMapper().getSchemaName(this.dumperContext.getLogicTableName());
        PipelineColumnMetaData firstColumn = this.dumperContext.getUniqueKeyColumns().get(0);
        List<String> columnNames = this.dumperContext.getQueryColumnNames();
        if (queryParam instanceof InventoryPointQueryParameter) {
            return this.sqlBuilder.buildPointQuerySQL(schemaName, this.dumperContext.getActualTableName(), columnNames, firstColumn.getName());
        }
        QueryRange queryRange = ((InventoryRangeQueryParameter)queryParam).getValue();
        boolean lowerInclusive = queryRange.isLowerInclusive();
        if (null != queryRange.getLower() && null != queryRange.getUpper()) {
            return this.sqlBuilder.buildDivisibleSQL(new BuildDivisibleSQLParameter(schemaName, this.dumperContext.getActualTableName(), columnNames, firstColumn.getName(), lowerInclusive, true));
        }
        if (null != queryRange.getLower()) {
            return this.sqlBuilder.buildDivisibleSQL(new BuildDivisibleSQLParameter(schemaName, this.dumperContext.getActualTableName(), columnNames, firstColumn.getName(), lowerInclusive, false));
        }
        throw new PipelineInternalException("Primary key position is invalid.", new Object[0]);
    }

    private Object getFirstUniqueKeyValue(List<Record> dataRecords, int index) {
        return ((DataRecord)dataRecords.get(index)).getUniqueKeyValue().iterator().next();
    }

    private void dumpWithStreamingQuery(Connection connection, PipelineTableMetaData tableMetaData) throws SQLException {
        int batchSize = this.dumperContext.getBatchSize();
        DatabaseType databaseType = this.dumperContext.getCommonContext().getDataSourceConfig().getDatabaseType();
        if (null != this.dumperContext.getTransactionIsolation()) {
            connection.setTransactionIsolation(this.dumperContext.getTransactionIsolation());
        }
        if (null == this.dumperContext.getQuerySQL()) {
            this.fetchAllQuery(connection, tableMetaData, databaseType, batchSize);
        } else {
            this.designatedParametersQuery(connection, tableMetaData, databaseType, batchSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchAllQuery(Connection connection, PipelineTableMetaData tableMetaData, DatabaseType databaseType, int batchSize) throws SQLException {
        log.info("Start to fetch all inventory data with streaming query, dataSource={}, actualTable={}", (Object)this.dumperContext.getCommonContext().getDataSourceName(), (Object)this.dumperContext.getActualTableName());
        try (PreparedStatement statement = JDBCStreamQueryBuilder.build(databaseType, connection, this.buildFetchAllSQLWithStreamingQuery(), batchSize);){
            this.runningStatement.set(statement);
            try (ResultSet resultSet = statement.executeQuery();){
                this.consumeResultSetToChannel(tableMetaData, resultSet, batchSize);
            }
            finally {
                this.runningStatement.set(null);
            }
        }
        log.info("End to fetch all inventory data with streaming query, dataSource={}, actualTable={}", (Object)this.dumperContext.getCommonContext().getDataSourceName(), (Object)this.dumperContext.getActualTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void designatedParametersQuery(Connection connection, PipelineTableMetaData tableMetaData, DatabaseType databaseType, int batchSize) throws SQLException {
        log.info("Start to dump inventory data with designated parameters query, dataSource={}, actualTable={}", (Object)this.dumperContext.getCommonContext().getDataSourceName(), (Object)this.dumperContext.getActualTableName());
        try (PreparedStatement statement = JDBCStreamQueryBuilder.build(databaseType, connection, this.dumperContext.getQuerySQL(), batchSize);){
            this.runningStatement.set(statement);
            for (int i = 0; i < this.dumperContext.getQueryParams().size(); ++i) {
                statement.setObject(i + 1, this.dumperContext.getQueryParams().get(i));
            }
            try (ResultSet resultSet = statement.executeQuery();){
                this.consumeResultSetToChannel(tableMetaData, resultSet, batchSize);
            }
            finally {
                this.runningStatement.set(null);
            }
        }
        log.info("End to dump inventory data with designated parameters query, dataSource={}, actualTable={}", (Object)this.dumperContext.getCommonContext().getDataSourceName(), (Object)this.dumperContext.getActualTableName());
    }

    private void consumeResultSetToChannel(PipelineTableMetaData tableMetaData, ResultSet resultSet, int batchSize) throws SQLException {
        int rowCount = 0;
        JobRateLimitAlgorithm rateLimitAlgorithm = this.dumperContext.getRateLimitAlgorithm();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        LinkedList<Record> dataRecords = new LinkedList<Record>();
        while (resultSet.next()) {
            if (dataRecords.size() >= batchSize) {
                this.channel.push(dataRecords);
                dataRecords = new LinkedList();
            }
            dataRecords.add(this.loadDataRecord(resultSet, resultSetMetaData, tableMetaData));
            ++rowCount;
            if (!this.isRunning()) {
                log.info("Broke because of inventory dump is not running.");
                break;
            }
            if (null == rateLimitAlgorithm || 0 != rowCount % batchSize) continue;
            rateLimitAlgorithm.intercept(PipelineSQLOperationType.SELECT, 1);
        }
        dataRecords.add(new FinishedRecord(new IngestFinishedPosition()));
        this.channel.push(dataRecords);
        log.info("Inventory dump with streaming query done, rowCount={}, dataSource={}, actualTable={}", new Object[]{rowCount, this.dumperContext.getCommonContext().getDataSourceName(), this.dumperContext.getActualTableName()});
    }

    private String buildFetchAllSQLWithStreamingQuery() {
        String schemaName = this.dumperContext.getCommonContext().getTableAndSchemaNameMapper().getSchemaName(this.dumperContext.getLogicTableName());
        List<String> columnNames = this.dumperContext.getQueryColumnNames();
        return this.sqlBuilder.buildFetchAllSQL(schemaName, this.dumperContext.getActualTableName(), columnNames);
    }

    @Override
    protected void doStop() {
        Optional.ofNullable(this.runningStatement.get()).ifPresent(PipelineJdbcUtils::cancelStatement);
    }
}

