/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.node;

import java.util.regex.Pattern;
import lombok.Generated;

public final class PipelineMetaDataNode {
    private static final String JOB_PATTERN_PREFIX = "/pipeline/jobs/(j\\d{2}\\d{2}[0-9a-z]+)";
    public static final Pattern CONFIG_PATTERN = Pattern.compile("/pipeline/jobs/(j\\d{2}\\d{2}[0-9a-z]+)/config");
    public static final Pattern BARRIER_PATTERN = Pattern.compile("/pipeline/jobs/(j\\d{2}\\d{2}[0-9a-z]+)/barrier/(enable|disable)/\\d+");

    public static String getMetaDataDataSourcesPath(String jobType) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getMetaDataRootPath(jobType), "data_sources");
    }

    private static String getMetaDataRootPath(String jobType) {
        return null == jobType ? String.join((CharSequence)"/", "/pipeline", "metadata") : String.join((CharSequence)"/", "/pipeline", jobType.toLowerCase(), "metadata");
    }

    public static String getMetaDataProcessConfigPath(String jobType) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getMetaDataRootPath(jobType), "process_config");
    }

    public static String getElasticJobNamespace() {
        return PipelineMetaDataNode.getJobsPath();
    }

    private static String getJobsPath() {
        return String.join((CharSequence)"/", "/pipeline", "jobs");
    }

    public static String getJobRootPath(String jobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobsPath(), jobId);
    }

    public static String getJobOffsetItemPath(String jobId, int shardingItem) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobOffsetPath(jobId), Integer.toString(shardingItem));
    }

    public static String getJobOffsetPath(String jobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobRootPath(jobId), "offset");
    }

    public static String getJobConfigurationPath(String jobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobRootPath(jobId), "config");
    }

    public static String getLatestCheckJobIdPath(String jobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobRootPath(jobId), "check", "latest_job_id");
    }

    public static String getCheckJobResultPath(String jobId, String checkJobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getCheckJobIdsRootPath(jobId), checkJobId);
    }

    public static String getCheckJobIdsRootPath(String jobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobRootPath(jobId), "check", "job_ids");
    }

    public static String getJobBarrierEnablePath(String jobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobRootPath(jobId), "barrier", "enable");
    }

    public static String getJobBarrierDisablePath(String jobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobRootPath(jobId), "barrier", "disable");
    }

    public static String getJobItemErrorMessagePath(String jobId, int shardingItem) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobRootPath(jobId), "error", Integer.toString(shardingItem));
    }

    @Generated
    private PipelineMetaDataNode() {
    }
}

