/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.expression.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;

public final class LiteralExpressionConverter {
    private static final Collection<String> TRIM_FUNCTION_FLAGS = new HashSet<String>(3, 1.0f);
    private static final Collection<String> TIME_UNIT_NAMES = new HashSet<String>(6, 1.0f);

    public static Optional<SqlNode> convert(LiteralExpressionSegment segment) {
        if (null == segment.getLiterals()) {
            return Optional.of(SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO));
        }
        String literalValue = String.valueOf(segment.getLiterals());
        if (TRIM_FUNCTION_FLAGS.contains(literalValue)) {
            return Optional.of(SqlLiteral.createSymbol((Enum)SqlTrimFunction.Flag.valueOf((String)literalValue), (SqlParserPos)SqlParserPos.ZERO));
        }
        if (TIME_UNIT_NAMES.contains(literalValue)) {
            return Optional.of(new SqlIntervalQualifier(TimeUnit.valueOf((String)literalValue), null, SqlParserPos.ZERO));
        }
        if (segment.getLiterals() instanceof Number) {
            return Optional.of(SqlLiteral.createExactNumeric((String)literalValue, (SqlParserPos)SqlParserPos.ZERO));
        }
        if (segment.getLiterals() instanceof String) {
            return Optional.of(SqlLiteral.createCharString((String)literalValue, (SqlParserPos)SqlParserPos.ZERO));
        }
        if (segment.getLiterals() instanceof Boolean) {
            return Optional.of(SqlLiteral.createBoolean((boolean)Boolean.parseBoolean(literalValue), (SqlParserPos)SqlParserPos.ZERO));
        }
        return Optional.empty();
    }

    @Generated
    private LiteralExpressionConverter() {
    }

    static {
        TRIM_FUNCTION_FLAGS.add("BOTH");
        TRIM_FUNCTION_FLAGS.add("LEADING");
        TRIM_FUNCTION_FLAGS.add("TRAILING");
        TIME_UNIT_NAMES.add("YEAR");
        TIME_UNIT_NAMES.add("MONTH");
        TIME_UNIT_NAMES.add("DAY");
        TIME_UNIT_NAMES.add("HOUR");
        TIME_UNIT_NAMES.add("MINUTE");
        TIME_UNIT_NAMES.add("SECOND");
    }
}

