/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.schedule;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.error.handler.JobErrorHandlerPropertiesValidator;
import org.apache.shardingsphere.elasticjob.executor.ElasticJobExecutor;
import org.apache.shardingsphere.elasticjob.executor.JobFacade;
import org.apache.shardingsphere.elasticjob.infra.exception.JobSystemException;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.infra.listener.ElasticJobListener;
import org.apache.shardingsphere.elasticjob.infra.listener.ElasticJobListenerFactory;
import org.apache.shardingsphere.elasticjob.infra.spi.ElasticJobServiceLoader;
import org.apache.shardingsphere.elasticjob.lite.api.listener.AbstractDistributeOnceElasticJobListener;
import org.apache.shardingsphere.elasticjob.lite.internal.config.ConfigurationService;
import org.apache.shardingsphere.elasticjob.lite.internal.guarantee.GuaranteeService;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobScheduleController;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobShutdownHookPlugin;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.LiteJob;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.LiteJobFacade;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.SchedulerFacade;
import org.apache.shardingsphere.elasticjob.lite.internal.setup.JobClassNameProviderFactory;
import org.apache.shardingsphere.elasticjob.lite.internal.setup.SetUpFacade;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.tracing.api.TracingConfiguration;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerListener;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.simpl.SimpleThreadPool;

public final class JobScheduler {
    private static final String JOB_EXECUTOR_DATA_MAP_KEY = "jobExecutor";
    private final CoordinatorRegistryCenter regCenter;
    private final JobConfiguration jobConfig;
    private final SetUpFacade setUpFacade;
    private final SchedulerFacade schedulerFacade;
    private final LiteJobFacade jobFacade;
    private final ElasticJobExecutor jobExecutor;
    private final JobScheduleController jobScheduleController;

    public JobScheduler(CoordinatorRegistryCenter regCenter, ElasticJob elasticJob, JobConfiguration jobConfig) {
        Preconditions.checkArgument((null != elasticJob ? 1 : 0) != 0, (Object)"Elastic job cannot be null.");
        this.regCenter = regCenter;
        String jobClassName = JobClassNameProviderFactory.getProvider().getJobClassName(elasticJob);
        this.jobConfig = this.setUpJobConfiguration(regCenter, jobClassName, jobConfig);
        Collection<ElasticJobListener> jobListeners = this.getElasticJobListeners(this.jobConfig);
        this.setUpFacade = new SetUpFacade(regCenter, this.jobConfig.getJobName(), jobListeners);
        this.schedulerFacade = new SchedulerFacade(regCenter, this.jobConfig.getJobName());
        this.jobFacade = new LiteJobFacade(regCenter, this.jobConfig.getJobName(), jobListeners, this.findTracingConfiguration().orElse(null));
        this.validateJobProperties();
        this.jobExecutor = new ElasticJobExecutor(elasticJob, this.jobConfig, (JobFacade)this.jobFacade);
        this.setGuaranteeServiceForElasticJobListeners(regCenter, jobListeners);
        this.jobScheduleController = this.createJobScheduleController();
    }

    public JobScheduler(CoordinatorRegistryCenter regCenter, String elasticJobType, JobConfiguration jobConfig) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)elasticJobType) ? 1 : 0) != 0, (Object)"Elastic job type cannot be null or empty.");
        this.regCenter = regCenter;
        this.jobConfig = this.setUpJobConfiguration(regCenter, elasticJobType, jobConfig);
        Collection<ElasticJobListener> jobListeners = this.getElasticJobListeners(this.jobConfig);
        this.setUpFacade = new SetUpFacade(regCenter, this.jobConfig.getJobName(), jobListeners);
        this.schedulerFacade = new SchedulerFacade(regCenter, this.jobConfig.getJobName());
        this.jobFacade = new LiteJobFacade(regCenter, this.jobConfig.getJobName(), jobListeners, this.findTracingConfiguration().orElse(null));
        this.validateJobProperties();
        this.jobExecutor = new ElasticJobExecutor(elasticJobType, this.jobConfig, (JobFacade)this.jobFacade);
        this.setGuaranteeServiceForElasticJobListeners(regCenter, jobListeners);
        this.jobScheduleController = this.createJobScheduleController();
    }

    private JobConfiguration setUpJobConfiguration(CoordinatorRegistryCenter regCenter, String jobClassName, JobConfiguration jobConfig) {
        ConfigurationService configService = new ConfigurationService(regCenter, jobConfig.getJobName());
        return configService.setUpJobConfiguration(jobClassName, jobConfig);
    }

    private Collection<ElasticJobListener> getElasticJobListeners(JobConfiguration jobConfig) {
        return jobConfig.getJobListenerTypes().stream().map(type -> (ElasticJobListener)ElasticJobListenerFactory.createListener((String)type).orElseThrow(() -> new IllegalArgumentException(String.format("Can not find job listener type '%s'.", type)))).collect(Collectors.toList());
    }

    private Optional<TracingConfiguration<?>> findTracingConfiguration() {
        return this.jobConfig.getExtraConfigurations().stream().filter(each -> each instanceof TracingConfiguration).findFirst().map(extraConfig -> (TracingConfiguration)extraConfig);
    }

    private void validateJobProperties() {
        this.validateJobErrorHandlerProperties();
    }

    private void validateJobErrorHandlerProperties() {
        if (null != this.jobConfig.getJobErrorHandlerType()) {
            ElasticJobServiceLoader.newTypedServiceInstance(JobErrorHandlerPropertiesValidator.class, (String)this.jobConfig.getJobErrorHandlerType(), (Properties)this.jobConfig.getProps()).ifPresent(validator -> validator.validate(this.jobConfig.getProps()));
        }
    }

    private void setGuaranteeServiceForElasticJobListeners(CoordinatorRegistryCenter regCenter, Collection<ElasticJobListener> elasticJobListeners) {
        GuaranteeService guaranteeService = new GuaranteeService(regCenter, this.jobConfig.getJobName());
        for (ElasticJobListener each : elasticJobListeners) {
            if (!(each instanceof AbstractDistributeOnceElasticJobListener)) continue;
            ((AbstractDistributeOnceElasticJobListener)each).setGuaranteeService(guaranteeService);
        }
    }

    private JobScheduleController createJobScheduleController() {
        JobScheduleController result = new JobScheduleController(this.createScheduler(), this.createJobDetail(), this.getJobConfig().getJobName());
        JobRegistry.getInstance().registerJob(this.getJobConfig().getJobName(), result);
        this.registerStartUpInfo();
        return result;
    }

    private Scheduler createScheduler() {
        Scheduler result;
        try {
            StdSchedulerFactory factory = new StdSchedulerFactory();
            factory.initialize(this.getQuartzProps());
            result = factory.getScheduler();
            result.getListenerManager().addTriggerListener((TriggerListener)this.schedulerFacade.newJobTriggerListener());
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
        return result;
    }

    private Properties getQuartzProps() {
        Properties result = new Properties();
        result.put("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
        result.put("org.quartz.threadPool.threadCount", "1");
        result.put("org.quartz.scheduler.instanceName", this.getJobConfig().getJobName());
        result.put("org.quartz.jobStore.misfireThreshold", "1");
        result.put("org.quartz.plugin.shutdownhook.class", JobShutdownHookPlugin.class.getName());
        result.put("org.quartz.plugin.shutdownhook.cleanShutdown", Boolean.TRUE.toString());
        return result;
    }

    private JobDetail createJobDetail() {
        JobDetail result = JobBuilder.newJob(LiteJob.class).withIdentity(this.getJobConfig().getJobName()).build();
        result.getJobDataMap().put(JOB_EXECUTOR_DATA_MAP_KEY, (Object)this.jobExecutor);
        return result;
    }

    private void registerStartUpInfo() {
        JobRegistry.getInstance().registerRegistryCenter(this.jobConfig.getJobName(), this.regCenter);
        JobRegistry.getInstance().addJobInstance(this.jobConfig.getJobName(), new JobInstance());
        JobRegistry.getInstance().setCurrentShardingTotalCount(this.jobConfig.getJobName(), this.jobConfig.getShardingTotalCount());
        this.setUpFacade.registerStartUpInfo(!this.jobConfig.isDisabled());
    }

    public void shutdown() {
        this.setUpFacade.tearDown();
        this.schedulerFacade.shutdownInstance();
        this.jobExecutor.shutdown();
    }

    @Generated
    public CoordinatorRegistryCenter getRegCenter() {
        return this.regCenter;
    }

    @Generated
    public JobConfiguration getJobConfig() {
        return this.jobConfig;
    }

    @Generated
    public JobScheduleController getJobScheduleController() {
        return this.jobScheduleController;
    }

    static {
        ElasticJobServiceLoader.registerTypedService(JobErrorHandlerPropertiesValidator.class);
    }
}

