/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.server;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shardingsphere.elasticjob.infra.concurrent.BlockUtils;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.server.ServerNode;
import org.apache.shardingsphere.elasticjob.lite.internal.server.ServerStatus;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.JobNodeStorage;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class ServerService {
    private final String jobName;
    private final JobNodeStorage jobNodeStorage;
    private final ServerNode serverNode;

    public ServerService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobName = jobName;
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.serverNode = new ServerNode(jobName);
    }

    public void persistOnline(boolean enabled) {
        if (!JobRegistry.getInstance().isShutdown(this.jobName)) {
            this.jobNodeStorage.fillJobNode(this.serverNode.getServerNode(JobRegistry.getInstance().getJobInstance(this.jobName).getServerIp()), enabled ? ServerStatus.ENABLED.name() : ServerStatus.DISABLED.name());
        }
    }

    public boolean hasAvailableServers() {
        List<String> servers = this.jobNodeStorage.getJobNodeChildrenKeys("servers");
        for (String each : servers) {
            if (!this.isAvailableServer(each)) continue;
            return true;
        }
        return false;
    }

    public boolean isAvailableServer(String ip) {
        return this.isEnableServer(ip) && this.hasOnlineInstances(ip);
    }

    private boolean hasOnlineInstances(String ip) {
        for (String each : this.jobNodeStorage.getJobNodeChildrenKeys("instances")) {
            if (!each.startsWith(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnableServer(String ip) {
        String serverStatus = this.jobNodeStorage.getJobNodeData(this.serverNode.getServerNode(ip));
        for (int i = 0; Strings.isNullOrEmpty((String)serverStatus) && i < 10; ++i) {
            BlockUtils.waitingShortTime();
            serverStatus = this.jobNodeStorage.getJobNodeData(this.serverNode.getServerNode(ip));
        }
        return ServerStatus.ENABLED.name().equals(serverStatus);
    }

    public int removeOfflineServers() {
        AtomicInteger affectNums = new AtomicInteger();
        List<String> instances = this.jobNodeStorage.getJobNodeChildrenKeys("instances");
        if (instances == null || instances.isEmpty()) {
            return affectNums.get();
        }
        Collection instanceIps = instances.stream().map(instance -> instance.split("@-@")[0]).collect(Collectors.toSet());
        if (instanceIps.isEmpty()) {
            return affectNums.get();
        }
        List<String> serverIps = this.jobNodeStorage.getJobNodeChildrenKeys("servers");
        if (serverIps == null || serverIps.isEmpty()) {
            return affectNums.get();
        }
        serverIps.forEach(serverIp -> {
            if (instanceIps.contains(serverIp)) {
                return;
            }
            String status = this.jobNodeStorage.getJobNodeData(this.serverNode.getServerNode((String)serverIp));
            if (StringUtils.isNotBlank((CharSequence)status)) {
                return;
            }
            this.jobNodeStorage.removeJobNodeIfExisted(this.serverNode.getServerNode((String)serverIp));
            affectNums.getAndIncrement();
        });
        return affectNums.get();
    }
}

