/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.manager;

import java.util.ArrayList;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereDatabaseData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereSchemaData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereTableData;
import org.apache.shardingsphere.infra.yaml.data.pojo.YamlShardingSphereRowData;
import org.apache.shardingsphere.infra.yaml.data.swapper.YamlShardingSphereRowDataSwapper;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;

public final class ShardingSphereDatabaseDataManager {
    private final MetaDataContexts metaDataContexts;

    public synchronized void addShardingSphereDatabaseData(String databaseName) {
        if (this.metaDataContexts.getStatistics().containsDatabase(databaseName)) {
            return;
        }
        this.metaDataContexts.getStatistics().putDatabase(databaseName, new ShardingSphereDatabaseData());
    }

    public synchronized void dropShardingSphereDatabaseData(String databaseName) {
        if (!this.metaDataContexts.getStatistics().containsDatabase(databaseName)) {
            return;
        }
        this.metaDataContexts.getStatistics().dropDatabase(databaseName);
    }

    public synchronized void addShardingSphereSchemaData(String databaseName, String schemaName) {
        if (this.metaDataContexts.getStatistics().getDatabase(databaseName).containsSchema(schemaName)) {
            return;
        }
        this.metaDataContexts.getStatistics().getDatabase(databaseName).putSchema(schemaName, new ShardingSphereSchemaData());
    }

    public synchronized void dropShardingSphereSchemaData(String databaseName, String schemaName) {
        ShardingSphereDatabaseData databaseData = this.metaDataContexts.getStatistics().getDatabase(databaseName);
        if (null == databaseData || !databaseData.containsSchema(schemaName)) {
            return;
        }
        databaseData.removeSchema(schemaName);
    }

    public synchronized void addShardingSphereTableData(String databaseName, String schemaName, String tableName) {
        if (!this.metaDataContexts.getStatistics().containsDatabase(databaseName) || !this.metaDataContexts.getStatistics().getDatabase(databaseName).containsSchema(schemaName)) {
            return;
        }
        if (this.metaDataContexts.getStatistics().getDatabase(databaseName).getSchema(schemaName).containsTable(tableName)) {
            return;
        }
        this.metaDataContexts.getStatistics().getDatabase(databaseName).getSchema(schemaName).putTable(tableName, new ShardingSphereTableData(tableName));
    }

    public synchronized void dropShardingSphereTableData(String databaseName, String schemaName, String tableName) {
        if (!this.metaDataContexts.getStatistics().containsDatabase(databaseName) || !this.metaDataContexts.getStatistics().getDatabase(databaseName).containsSchema(schemaName)) {
            return;
        }
        this.metaDataContexts.getStatistics().getDatabase(databaseName).getSchema(schemaName).removeTable(tableName);
    }

    public synchronized void alterShardingSphereRowData(String databaseName, String schemaName, String tableName, YamlShardingSphereRowData yamlRowData) {
        if (!(this.metaDataContexts.getStatistics().containsDatabase(databaseName) && this.metaDataContexts.getStatistics().getDatabase(databaseName).containsSchema(schemaName) && this.metaDataContexts.getStatistics().getDatabase(databaseName).getSchema(schemaName).containsTable(tableName))) {
            return;
        }
        if (!(this.metaDataContexts.getMetaData().containsDatabase(databaseName) && this.metaDataContexts.getMetaData().getDatabase(databaseName).containsSchema(schemaName) && this.metaDataContexts.getMetaData().getDatabase(databaseName).getSchema(schemaName).containsTable(tableName))) {
            return;
        }
        ShardingSphereTableData tableData = this.metaDataContexts.getStatistics().getDatabase(databaseName).getSchema(schemaName).getTable(tableName);
        ArrayList columns = new ArrayList(this.metaDataContexts.getMetaData().getDatabase(databaseName).getSchema(schemaName).getTable(tableName).getAllColumns());
        tableData.getRows().add(new YamlShardingSphereRowDataSwapper(columns).swapToObject(yamlRowData));
    }

    public synchronized void deleteShardingSphereRowData(String databaseName, String schemaName, String tableName, String uniqueKey) {
        if (!(this.metaDataContexts.getStatistics().containsDatabase(databaseName) && this.metaDataContexts.getStatistics().getDatabase(databaseName).containsSchema(schemaName) && this.metaDataContexts.getStatistics().getDatabase(databaseName).getSchema(schemaName).containsTable(tableName))) {
            return;
        }
        this.metaDataContexts.getStatistics().getDatabase(databaseName).getSchema(schemaName).getTable(tableName).getRows().removeIf(each -> uniqueKey.equals(each.getUniqueKey()));
    }

    @Generated
    public ShardingSphereDatabaseDataManager(MetaDataContexts metaDataContexts) {
        this.metaDataContexts = metaDataContexts;
    }
}

