/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service.config.database;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.metadata.version.MetaDataVersion;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.mode.metadata.persist.service.config.RepositoryTuplePersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.version.MetaDataVersionPersistService;
import org.apache.shardingsphere.mode.node.path.metadata.DatabaseRuleMetaDataNodePath;
import org.apache.shardingsphere.mode.node.tuple.RepositoryTuple;
import org.apache.shardingsphere.mode.node.tuple.RepositoryTupleSwapperEngine;
import org.apache.shardingsphere.mode.node.tuple.annotation.RepositoryTupleEntity;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class DatabaseRulePersistService {
    private final PersistRepository repository;
    private final RepositoryTuplePersistService repositoryTuplePersistService;
    private final MetaDataVersionPersistService metaDataVersionPersistService;

    public DatabaseRulePersistService(PersistRepository repository) {
        this.repository = repository;
        this.repositoryTuplePersistService = new RepositoryTuplePersistService(repository);
        this.metaDataVersionPersistService = new MetaDataVersionPersistService(repository);
    }

    public Collection<RuleConfiguration> load(String databaseName) {
        return new RepositoryTupleSwapperEngine().swapToRuleConfigurations(this.repositoryTuplePersistService.load(DatabaseRuleMetaDataNodePath.getRootPath((String)databaseName)));
    }

    public Collection<MetaDataVersion> persist(String databaseName, Collection<RuleConfiguration> configs) {
        LinkedList<MetaDataVersion> result = new LinkedList<MetaDataVersion>();
        RepositoryTupleSwapperEngine repositoryTupleSwapperEngine = new RepositoryTupleSwapperEngine();
        for (YamlRuleConfiguration each : new YamlRuleConfigurationSwapperEngine().swapToYamlRuleConfigurations(configs)) {
            Collection repositoryTuples = repositoryTupleSwapperEngine.swapToRepositoryTuples(each);
            if (repositoryTuples.isEmpty()) continue;
            result.addAll(this.persistDataNodes(databaseName, Objects.requireNonNull(each.getClass().getAnnotation(RepositoryTupleEntity.class)).value(), repositoryTuples));
        }
        return result;
    }

    private Collection<MetaDataVersion> persistDataNodes(String databaseName, String ruleName, Collection<RepositoryTuple> repositoryTuples) {
        LinkedList<MetaDataVersion> result = new LinkedList<MetaDataVersion>();
        for (RepositoryTuple each : repositoryTuples) {
            List<String> versions = this.metaDataVersionPersistService.getVersions(DatabaseRuleMetaDataNodePath.getVersionsPath((String)databaseName, (String)ruleName, (String)each.getKey()));
            String nextVersion = versions.isEmpty() ? "0" : String.valueOf(Integer.parseInt(versions.get(0)) + 1);
            this.repository.persist(DatabaseRuleMetaDataNodePath.getVersionPath((String)databaseName, (String)ruleName, (String)each.getKey(), (String)nextVersion), each.getValue());
            if (Strings.isNullOrEmpty((String)this.getActiveVersion(databaseName, ruleName, each.getKey()))) {
                this.repository.persist(DatabaseRuleMetaDataNodePath.getActiveVersionPath((String)databaseName, (String)ruleName, (String)each.getKey()), "0");
            }
            result.add(new MetaDataVersion(DatabaseRuleMetaDataNodePath.getRulePath((String)databaseName, (String)ruleName, (String)each.getKey()), this.getActiveVersion(databaseName, ruleName, each.getKey()), nextVersion));
        }
        return result;
    }

    private String getActiveVersion(String databaseName, String ruleName, String key) {
        return this.repository.query(DatabaseRuleMetaDataNodePath.getActiveVersionPath((String)databaseName, (String)ruleName, (String)key));
    }

    public void delete(String databaseName, String ruleTypeName) {
        this.repository.delete(DatabaseRuleMetaDataNodePath.getRulePath((String)databaseName, (String)ruleTypeName));
    }

    public Collection<MetaDataVersion> delete(String databaseName, Collection<RuleConfiguration> configs) {
        LinkedList<MetaDataVersion> result = new LinkedList<MetaDataVersion>();
        RepositoryTupleSwapperEngine repositoryTupleSwapperEngine = new RepositoryTupleSwapperEngine();
        for (YamlRuleConfiguration each : new YamlRuleConfigurationSwapperEngine().swapToYamlRuleConfigurations(configs)) {
            Collection repositoryTuples = repositoryTupleSwapperEngine.swapToRepositoryTuples(each);
            if (repositoryTuples.isEmpty()) continue;
            LinkedList<RepositoryTuple> newRepositoryTuples = new LinkedList<RepositoryTuple>(repositoryTuples);
            Collections.reverse(newRepositoryTuples);
            result.addAll(this.delete(databaseName, Objects.requireNonNull(each.getClass().getAnnotation(RepositoryTupleEntity.class)).value(), newRepositoryTuples));
        }
        return result;
    }

    private Collection<MetaDataVersion> delete(String databaseName, String ruleName, Collection<RepositoryTuple> repositoryTuples) {
        LinkedList<MetaDataVersion> result = new LinkedList<MetaDataVersion>();
        for (RepositoryTuple each : repositoryTuples) {
            String toBeDeletedKey = DatabaseRuleMetaDataNodePath.getRulePath((String)databaseName, (String)ruleName, (String)each.getKey());
            this.repository.delete(toBeDeletedKey);
            result.add(new MetaDataVersion(toBeDeletedKey));
        }
        return result;
    }
}

