/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.metadata.refresher.FederationMetaDataRefresher;
import org.apache.shardingsphere.mode.metadata.refresher.MetaDataRefresher;
import org.apache.shardingsphere.mode.persist.service.divided.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.AlterIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.AlterSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.AlterTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.RenameTableStatement;

public final class MetaDataRefreshEngine {
    private static final Collection<Class<? extends DDLStatement>> DDL_STATEMENT_CLASSES = Arrays.asList(CreateTableStatement.class, AlterTableStatement.class, DropTableStatement.class, CreateViewStatement.class, AlterViewStatement.class, DropViewStatement.class, CreateIndexStatement.class, AlterIndexStatement.class, DropIndexStatement.class, CreateSchemaStatement.class, AlterSchemaStatement.class, DropSchemaStatement.class, RenameTableStatement.class);
    private final MetaDataManagerPersistService metaDataManagerPersistService;
    private final ShardingSphereDatabase database;
    private final ConfigurationProperties props;

    public void refresh(SQLStatementContext sqlStatementContext, Collection<RouteUnit> routeUnits) throws SQLException {
        Class<?> sqlStatementClass = sqlStatementContext.getSqlStatement().getClass().getSuperclass();
        if (!DDL_STATEMENT_CLASSES.contains(sqlStatementClass)) {
            return;
        }
        Optional schemaRefresher = TypedSPILoader.findService(MetaDataRefresher.class, sqlStatementClass);
        if (schemaRefresher.isPresent()) {
            Collection logicDataSourceNames = routeUnits.stream().map(each -> each.getDataSourceMapper().getLogicName()).collect(Collectors.toList());
            String schemaName = sqlStatementContext instanceof TableAvailable ? this.getSchemaName(sqlStatementContext) : null;
            DatabaseType databaseType = routeUnits.stream().map(each -> (StorageUnit)this.database.getResourceMetaData().getStorageUnits().get(each.getDataSourceMapper().getActualName())).filter(Objects::nonNull).findFirst().map(StorageUnit::getStorageType).orElseGet(() -> ((SQLStatementContext)sqlStatementContext).getDatabaseType());
            ((MetaDataRefresher)schemaRefresher.get()).refresh(this.metaDataManagerPersistService, this.database, logicDataSourceNames, schemaName, databaseType, sqlStatementContext.getSqlStatement(), this.props);
        }
    }

    public void refresh(SQLStatementContext sqlStatementContext) {
        this.getFederationMetaDataRefresher(sqlStatementContext).ifPresent(optional -> optional.refresh(this.metaDataManagerPersistService, this.database, this.getSchemaName(sqlStatementContext), sqlStatementContext.getDatabaseType(), sqlStatementContext.getSqlStatement()));
    }

    private String getSchemaName(SQLStatementContext sqlStatementContext) {
        return ((TableAvailable)sqlStatementContext).getTablesContext().getSchemaName().orElseGet(() -> new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(this.database.getName())).toLowerCase();
    }

    public boolean isFederation(SQLStatementContext sqlStatementContext) {
        return this.getFederationMetaDataRefresher(sqlStatementContext).isPresent();
    }

    private Optional<FederationMetaDataRefresher> getFederationMetaDataRefresher(SQLStatementContext sqlStatementContext) {
        return TypedSPILoader.findService(FederationMetaDataRefresher.class, sqlStatementContext.getSqlStatement().getClass().getSuperclass());
    }

    public static boolean isRefreshMetaDataRequired(SQLStatementContext sqlStatementContext) {
        return DDL_STATEMENT_CLASSES.contains(sqlStatementContext.getSqlStatement().getClass().getSuperclass());
    }

    @Generated
    public MetaDataRefreshEngine(MetaDataManagerPersistService metaDataManagerPersistService, ShardingSphereDatabase database, ConfigurationProperties props) {
        this.metaDataManagerPersistService = metaDataManagerPersistService;
        this.database = database;
        this.props = props;
    }
}

