/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.converter;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.readwritesplitting.config.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.config.rule.ReadwriteSplittingDataSourceGroupRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.distsql.segment.ReadwriteSplittingRuleSegment;
import org.apache.shardingsphere.readwritesplitting.transaction.TransactionalReadQueryStrategy;

public final class ReadwriteSplittingRuleStatementConverter {
    public static ReadwriteSplittingRuleConfiguration convert(Collection<ReadwriteSplittingRuleSegment> ruleSegments) {
        LinkedList<ReadwriteSplittingDataSourceGroupRuleConfiguration> dataSourceGroups = new LinkedList<ReadwriteSplittingDataSourceGroupRuleConfiguration>();
        HashMap<String, AlgorithmConfiguration> loadBalancers = new HashMap<String, AlgorithmConfiguration>(ruleSegments.size(), 1.0f);
        for (ReadwriteSplittingRuleSegment each : ruleSegments) {
            if (null == each.getLoadBalancer()) {
                dataSourceGroups.add(ReadwriteSplittingRuleStatementConverter.createDataSourceGroupRuleConfiguration(each, null));
                continue;
            }
            String loadBalancerName = ReadwriteSplittingRuleStatementConverter.getLoadBalancerName(each.getName(), each.getLoadBalancer().getName());
            loadBalancers.put(loadBalancerName, ReadwriteSplittingRuleStatementConverter.createLoadBalancer(each));
            dataSourceGroups.add(ReadwriteSplittingRuleStatementConverter.createDataSourceGroupRuleConfiguration(each, loadBalancerName));
        }
        return new ReadwriteSplittingRuleConfiguration(dataSourceGroups, loadBalancers);
    }

    private static ReadwriteSplittingDataSourceGroupRuleConfiguration createDataSourceGroupRuleConfiguration(ReadwriteSplittingRuleSegment segment, String loadBalancerName) {
        return null == segment.getTransactionalReadQueryStrategy() ? new ReadwriteSplittingDataSourceGroupRuleConfiguration(segment.getName(), segment.getWriteDataSource(), new LinkedList(segment.getReadDataSources()), loadBalancerName) : new ReadwriteSplittingDataSourceGroupRuleConfiguration(segment.getName(), segment.getWriteDataSource(), new LinkedList(segment.getReadDataSources()), TransactionalReadQueryStrategy.valueOf((String)segment.getTransactionalReadQueryStrategy().toUpperCase()), loadBalancerName);
    }

    private static AlgorithmConfiguration createLoadBalancer(ReadwriteSplittingRuleSegment ruleSegment) {
        return new AlgorithmConfiguration(ruleSegment.getLoadBalancer().getName(), ruleSegment.getLoadBalancer().getProps());
    }

    private static String getLoadBalancerName(String ruleName, String type) {
        return String.format("%s_%s", ruleName, type);
    }

    @Generated
    private ReadwriteSplittingRuleStatementConverter() {
    }
}

