/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.metadata;

import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.checker.ActiveVersionChecker;
import org.apache.shardingsphere.mode.metadata.refresher.ShardingSphereStatisticsRefreshEngine;
import org.apache.shardingsphere.mode.node.path.metadata.ViewMetaDataNodePath;

public final class ViewChangedHandler {
    private final ContextManager contextManager;
    private final ShardingSphereStatisticsRefreshEngine statisticsRefreshEngine;

    public ViewChangedHandler(ContextManager contextManager) {
        this.contextManager = contextManager;
        this.statisticsRefreshEngine = new ShardingSphereStatisticsRefreshEngine(contextManager);
    }

    public void handleCreatedOrAltered(String databaseName, String schemaName, DataChangedEvent event) {
        String viewName = (String)ViewMetaDataNodePath.getViewNameByActiveVersionPath((String)event.getKey()).orElseThrow(() -> new IllegalStateException("View name not found."));
        ActiveVersionChecker.checkActiveVersion(this.contextManager, event);
        ShardingSphereView view = this.contextManager.getPersistServiceFacade().getMetaDataPersistService().getDatabaseMetaDataFacade().getView().load(databaseName, schemaName, viewName);
        this.contextManager.getMetaDataContextManager().getSchemaMetaDataManager().alterSchema(databaseName, schemaName, null, view);
        this.statisticsRefreshEngine.asyncRefresh();
    }

    public void handleDropped(String databaseName, String schemaName, DataChangedEvent event) {
        String viewName = (String)ViewMetaDataNodePath.findViewName((String)event.getKey()).orElseThrow(() -> new IllegalStateException("View name not found."));
        this.contextManager.getMetaDataContextManager().getSchemaMetaDataManager().alterSchema(databaseName, schemaName, null, viewName);
        this.statisticsRefreshEngine.asyncRefresh();
    }
}

