/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global;

import java.util.Arrays;
import java.util.Collection;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.checker.ActiveVersionChecker;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.DataChangedEventHandler;
import org.apache.shardingsphere.mode.node.path.GlobalPropertiesNodePath;

public final class PropertiesChangedHandler
implements DataChangedEventHandler {
    @Override
    public String getSubscribedKey() {
        return GlobalPropertiesNodePath.getRootPath();
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED);
    }

    @Override
    public void handle(ContextManager contextManager, DataChangedEvent event) {
        if (!GlobalPropertiesNodePath.isActiveVersionPath((String)event.getKey())) {
            return;
        }
        ActiveVersionChecker.checkActiveVersion(contextManager, event);
        contextManager.getMetaDataContextManager().getGlobalConfigurationManager().alterProperties(contextManager.getPersistServiceFacade().getMetaDataPersistService().getPropsService().load());
    }
}

